/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeNameExtractor;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Map;

class FunctionNames
implements CompilerPass,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient AbstractCompiler compiler;
    private final Map<Node, FunctionRecord> functionMap = Maps.newLinkedHashMap();
    private final transient FunctionListExtractor functionListExtractor;

    FunctionNames(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functionListExtractor = new FunctionListExtractor(this.functionMap);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this.functionListExtractor);
        FunctionExpressionNamer namer = new FunctionExpressionNamer(this.functionMap);
        AnonymousFunctionNamingCallback namingCallback = new AnonymousFunctionNamingCallback(namer);
        NodeTraversal.traverse(this.compiler, root, namingCallback);
    }

    public Iterable<Node> getFunctionNodeList() {
        return this.functionMap.keySet();
    }

    public int getFunctionId(Node f) {
        FunctionRecord record = this.functionMap.get(f);
        if (record != null) {
            return record.id;
        }
        return -1;
    }

    public String getFunctionName(Node f) {
        Node parent;
        FunctionRecord record = this.functionMap.get(f);
        if (record == null) {
            return null;
        }
        String str = record.name;
        if (str.isEmpty()) {
            str = "<anonymous>";
        }
        if ((parent = record.parent) != null) {
            str = this.getFunctionName(parent) + "::" + str;
        }
        str = str.replaceAll("::this\\.", ".");
        str = str.replaceAll("\\.\\.", ".");
        str = str.replaceFirst("^(<anonymous>::)*", "");
        return str;
    }

    private static class FunctionExpressionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        private static final char DELIMITER = '.';
        private static final NodeNameExtractor extractor = new NodeNameExtractor('.');
        private final Map<Node, FunctionRecord> functionMap;

        FunctionExpressionNamer(Map<Node, FunctionRecord> functionMap) {
            this.functionMap = functionMap;
        }

        @Override
        public final String getName(Node node) {
            return extractor.getName(node);
        }

        @Override
        public final void setFunctionName(String name, Node fnNode) {
            FunctionRecord record = this.functionMap.get(fnNode);
            assert (record != null);
            assert (record.name.isEmpty());
            record.name = name;
        }

        @Override
        public final String getCombinedName(String lhs, String rhs) {
            return lhs + '.' + rhs;
        }
    }

    private static class FunctionListExtractor
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Map<Node, FunctionRecord> functionMap;
        private int nextId = 0;

        FunctionListExtractor(Map<Node, FunctionRecord> functionMap) {
            this.functionMap = functionMap;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                Node functionNameNode = n.getFirstChild();
                String functionName = functionNameNode.getString();
                Node enclosingFunction = t.getEnclosingFunction();
                this.functionMap.put(n, new FunctionRecord(this.nextId, enclosingFunction, functionName));
                ++this.nextId;
            }
        }
    }

    private static class FunctionRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int id;
        public final Node parent;
        public String name;

        FunctionRecord(int id, Node parent, String name) {
            this.id = id;
            this.parent = parent;
            this.name = name;
        }
    }
}

