/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionSite;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionsRemover;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.OptimizeCalls;
import com.google.gwt.thirdparty.javascript.jscomp.SimpleDefinitionFinder;
import com.google.gwt.thirdparty.javascript.jscomp.UseSite;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;

class OptimizeReturns
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private AbstractCompiler compiler;

    OptimizeReturns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node externs, Node root) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, SimpleDefinitionFinder definitions) {
        ArrayList toOptimize = Lists.newArrayList();
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            if (defSite.inExterns || this.callResultsMaybeUsed(definitions, defSite)) continue;
            toOptimize.add(defSite.definition.getRValue());
        }
        for (Node node : toOptimize) {
            this.rewriteReturns(definitions, node);
        }
    }

    private boolean callResultsMaybeUsed(SimpleDefinitionFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction()) {
            return true;
        }
        if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(rValue)) {
            return true;
        }
        if (!defFinder.canModifyDefinition(definition)) {
            return true;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node useNodeParent = site.node.getParent();
            if (OptimizeReturns.isCall(site)) {
                Node callNode = useNodeParent;
                Preconditions.checkState((boolean)callNode.isCall());
                if (!NodeUtil.isExpressionResultUsed(callNode)) continue;
                return true;
            }
            if (useNodeParent.isVar()) continue;
            return true;
        }
        return false;
    }

    private void rewriteReturns(final SimpleDefinitionFinder defFinder, Node fnNode) {
        Preconditions.checkState((boolean)fnNode.isFunction());
        NodeUtil.visitPostOrder(fnNode.getLastChild(), new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (node.isReturn() && node.hasOneChild()) {
                    boolean keepValue = NodeUtil.mayHaveSideEffects(node.getFirstChild(), OptimizeReturns.this.compiler);
                    if (!keepValue) {
                        defFinder.removeReferences(node.getFirstChild());
                    }
                    Node result = node.removeFirstChild();
                    if (keepValue) {
                        node.getParent().addChildBefore(IR.exprResult(result).srcref(result), node);
                    }
                    OptimizeReturns.this.compiler.reportCodeChange();
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        return parent.getFirstChild() == node && parent.isCall();
    }
}

