/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Set;
import javax.annotation.Nullable;

class StripCode
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<String> stripTypes;
    private final Set<String> stripNameSuffixes;
    private final Set<String> stripTypePrefixes;
    private final Set<String> stripNamePrefixes;
    private final Set<Scope.Var> varsToRemove;
    static final DiagnosticType STRIP_TYPE_INHERIT_ERROR = DiagnosticType.error("JSC_STRIP_TYPE_INHERIT_ERROR", "Non-strip type {0} cannot inherit from strip type {1}");
    static final DiagnosticType STRIP_ASSIGNMENT_ERROR = DiagnosticType.error("JSC_STRIP_ASSIGNMENT_ERROR", "Unable to strip assignment to {0}");

    StripCode(AbstractCompiler compiler, Set<String> stripTypes, Set<String> stripNameSuffixes, Set<String> stripTypePrefixes, Set<String> stripNamePrefixes) {
        this.compiler = compiler;
        this.stripTypes = Sets.newHashSet(stripTypes);
        this.stripNameSuffixes = Sets.newHashSet(stripNameSuffixes);
        this.stripTypePrefixes = Sets.newHashSet(stripTypePrefixes);
        this.stripNamePrefixes = Sets.newHashSet(stripNamePrefixes);
        this.varsToRemove = Sets.newHashSet();
    }

    public void enableTweakStripping() {
        this.stripTypes.add("goog.tweak");
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new Strip());
    }

    private class Strip
    extends NodeTraversal.AbstractPostOrderCallback {
        private Strip() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 118: {
                    this.removeVarDeclarationsByNameOrRvalue(t, n, parent);
                    break;
                }
                case 38: {
                    this.maybeRemoveReferenceToRemovedVariable(t, n, parent);
                    break;
                }
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    this.maybeEliminateAssignmentByLvalueName(t, n, parent);
                    break;
                }
                case 30: 
                case 37: {
                    this.maybeRemoveCall(t, n, parent);
                    break;
                }
                case 64: {
                    this.eliminateKeysWithStripNamesFromObjLit(t, n);
                    break;
                }
                case 130: {
                    this.maybeEliminateExpressionByName(t, n, parent);
                }
            }
        }

        void removeVarDeclarationsByNameOrRvalue(NodeTraversal t, Node n, Node parent) {
            for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                String name = nameNode.getString();
                if (!this.isStripName(name) && !this.isCallWhoseReturnValueShouldBeStripped(nameNode.getFirstChild())) continue;
                Scope scope = t.getScope();
                StripCode.this.varsToRemove.add(scope.getVar(name));
                n.removeChild(nameNode);
                StripCode.this.compiler.reportCodeChange();
            }
            if (!n.hasChildren()) {
                this.replaceWithEmpty(n, parent);
                StripCode.this.compiler.reportCodeChange();
            }
        }

        void maybeRemoveReferenceToRemovedVariable(NodeTraversal t, Node n, Node parent) {
            switch (parent.getType()) {
                case 118: {
                    break;
                }
                case 33: 
                case 35: {
                    if (parent.getFirstChild() != n || !this.isReferenceToRemovedVar(t, n)) break;
                    this.replaceHighestNestedCallWithNull(parent, parent.getParent());
                    break;
                }
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    if (!this.isReferenceToRemovedVar(t, n)) break;
                    if (parent.getFirstChild() == n) {
                        Node gramps = parent.getParent();
                        if (gramps.isExprResult()) {
                            Node greatGramps = gramps.getParent();
                            this.replaceWithEmpty(gramps, greatGramps);
                            StripCode.this.compiler.reportCodeChange();
                            break;
                        }
                        Node rvalue = n.getNext();
                        parent.removeChild(rvalue);
                        gramps.replaceChild(parent, rvalue);
                        StripCode.this.compiler.reportCodeChange();
                        break;
                    }
                    this.replaceWithNull(n, parent);
                    StripCode.this.compiler.reportCodeChange();
                    break;
                }
                default: {
                    if (!this.isReferenceToRemovedVar(t, n)) break;
                    this.replaceWithNull(n, parent);
                    StripCode.this.compiler.reportCodeChange();
                }
            }
        }

        void replaceHighestNestedCallWithNull(Node node, Node parent) {
            Node ancestor = parent;
            Node ancestorChild = node;
            while (true) {
                if (ancestor.getFirstChild() != ancestorChild) {
                    this.replaceWithNull(ancestorChild, ancestor);
                    break;
                }
                if (ancestor.isExprResult()) {
                    Node ancParent = ancestor.getParent();
                    this.replaceWithEmpty(ancestor, ancParent);
                    break;
                }
                if (ancestor.isAssign()) {
                    Node ancParent = ancestor.getParent();
                    ancParent.replaceChild(ancestor, ancestor.getLastChild().detachFromParent());
                    break;
                }
                if (!NodeUtil.isGet(ancestor) && !ancestor.isCall()) {
                    this.replaceWithNull(ancestorChild, ancestor);
                    break;
                }
                ancestorChild = ancestor;
                ancestor = ancestor.getParent();
            }
            StripCode.this.compiler.reportCodeChange();
        }

        void maybeEliminateAssignmentByLvalueName(NodeTraversal t, Node n, Node parent) {
            Node lvalue = n.getFirstChild();
            if (this.nameIncludesFieldNameToStrip(lvalue) || this.qualifiedNameBeginsWithStripType(lvalue)) {
                if (parent.isExprResult()) {
                    Node gramps = parent.getParent();
                    this.replaceWithEmpty(parent, gramps);
                    StripCode.this.compiler.reportCodeChange();
                } else {
                    t.report(n, STRIP_ASSIGNMENT_ERROR, lvalue.getQualifiedName());
                }
            }
        }

        void maybeEliminateExpressionByName(NodeTraversal t, Node n, Node parent) {
            Node expression = n.getFirstChild();
            if (this.nameIncludesFieldNameToStrip(expression) || this.qualifiedNameBeginsWithStripType(expression)) {
                if (parent.isExprResult()) {
                    Node gramps = parent.getParent();
                    this.replaceWithEmpty(parent, gramps);
                } else {
                    this.replaceWithEmpty(n, parent);
                }
                StripCode.this.compiler.reportCodeChange();
            }
        }

        void maybeRemoveCall(NodeTraversal t, Node n, Node parent) {
            if (this.isMethodOrCtorCallThatTriggersRemoval(t, n, parent)) {
                this.replaceHighestNestedCallWithNull(n, parent);
            }
        }

        void eliminateKeysWithStripNamesFromObjLit(NodeTraversal t, Node n) {
            Node key = n.getFirstChild();
            while (key != null) {
                if (this.isStripName(key.getString())) {
                    Node next = key.getNext();
                    n.removeChild(key);
                    key = next;
                    StripCode.this.compiler.reportCodeChange();
                    continue;
                }
                key = key.getNext();
            }
        }

        boolean isCallWhoseReturnValueShouldBeStripped(@Nullable Node n) {
            return !(n == null || !n.isCall() && !n.isNew() || !n.hasChildren() || !this.qualifiedNameBeginsWithStripType(n.getFirstChild()) && !this.nameIncludesFieldNameToStrip(n.getFirstChild()));
        }

        boolean qualifiedNameBeginsWithStripType(Node n) {
            String name = n.getQualifiedName();
            return this.qualifiedNameBeginsWithStripType(name);
        }

        boolean qualifiedNameBeginsWithStripType(String name) {
            if (name != null) {
                for (String type : StripCode.this.stripTypes) {
                    if (!name.equals(type) && !name.startsWith(type + ".")) continue;
                    return true;
                }
                for (String type : StripCode.this.stripTypePrefixes) {
                    if (!name.startsWith(type)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isReferenceToRemovedVar(NodeTraversal t, Node n) {
            String name = n.getString();
            Scope scope = t.getScope();
            Scope.Var var = scope.getVar(name);
            return StripCode.this.varsToRemove.contains(var);
        }

        boolean isMethodOrCtorCallThatTriggersRemoval(NodeTraversal t, Node n, Node parent) {
            Node gramps;
            Node function = n.getFirstChild();
            if (function == null || !function.isGetProp()) {
                return false;
            }
            if (parent != null && parent.isName() && (gramps = parent.getParent()) != null && gramps.isVar()) {
                return false;
            }
            Node callee = function.getFirstChild();
            return this.nameIncludesFieldNameToStrip(callee) || this.nameIncludesFieldNameToStrip(function) || this.qualifiedNameBeginsWithStripType(function) || this.actsOnStripType(t, n);
        }

        boolean nameIncludesFieldNameToStrip(@Nullable Node n) {
            if (n != null && n.isGetProp()) {
                Node propNode = n.getLastChild();
                return this.isStripName(propNode.getString()) || this.nameIncludesFieldNameToStrip(n.getFirstChild());
            }
            return false;
        }

        private boolean actsOnStripType(NodeTraversal t, Node callNode) {
            CodingConvention.SubclassRelationship classes = StripCode.this.compiler.getCodingConvention().getClassesDefinedByCall(callNode);
            if (classes != null) {
                if (this.qualifiedNameBeginsWithStripType(classes.subclassName)) {
                    return true;
                }
                if (this.qualifiedNameBeginsWithStripType(classes.superclassName)) {
                    t.report(callNode, STRIP_TYPE_INHERIT_ERROR, classes.subclassName, classes.superclassName);
                }
            }
            return false;
        }

        boolean isStripName(String name) {
            if (StripCode.this.stripNameSuffixes.contains(name) || StripCode.this.stripNamePrefixes.contains(name)) {
                return true;
            }
            if (name.length() == 0 || Character.isUpperCase(name.charAt(0))) {
                return false;
            }
            String lcName = name.toLowerCase();
            for (String stripName : StripCode.this.stripNamePrefixes) {
                if (!lcName.startsWith(stripName.toLowerCase())) continue;
                return true;
            }
            for (String stripName : StripCode.this.stripNameSuffixes) {
                if (!lcName.endsWith(stripName.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        void replaceWithNull(Node n, Node parent) {
            parent.replaceChild(n, IR.nullNode());
        }

        void replaceWithEmpty(Node n, Node parent) {
            NodeUtil.removeChild(parent, n);
        }
    }
}

