/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.gwt.thirdparty.javascript.jscomp.JsMessage;
import com.google.gwt.thirdparty.javascript.jscomp.JsMessageVisitor;
import com.google.gwt.thirdparty.javascript.jscomp.MessageBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XtbMessageBundle
implements MessageBundle {
    private static final SecureEntityResolver NOOP_RESOLVER = new SecureEntityResolver();
    private final Map<String, JsMessage> messages;
    private final JsMessage.IdGenerator idGenerator;

    public XtbMessageBundle(InputStream xtb, @Nullable String projectId, boolean unused) {
        this(xtb, projectId);
    }

    public XtbMessageBundle(InputStream xtb, @Nullable String projectId) {
        Preconditions.checkState((!"".equals(projectId) ? 1 : 0) != 0);
        this.messages = Maps.newHashMap();
        this.idGenerator = new GoogleJsMessageIdGenerator(projectId);
        try {
            SAXParser parser2 = this.createSAXParser();
            XMLReader reader = parser2.getXMLReader();
            Handler contentHandler = new Handler();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(xtb));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SAXParser createSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser parser2 = factory.newSAXParser();
        XMLReader xmlReader = parser2.getXMLReader();
        xmlReader.setEntityResolver(NOOP_RESOLVER);
        return parser2;
    }

    @Override
    public JsMessage getMessage(String id) {
        return this.messages.get(id);
    }

    @Override
    public JsMessage.IdGenerator idGenerator() {
        return this.idGenerator;
    }

    @Override
    public Iterable<JsMessage> getAllMessages() {
        return Iterables.unmodifiableIterable(this.messages.values());
    }

    private static final class SecureEntityResolver
    implements EntityResolver {
        private SecureEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }

    private class Handler
    implements ContentHandler {
        private static final String BUNDLE_ELEM_NAME = "translationbundle";
        private static final String LANG_ATT_NAME = "lang";
        private static final String TRANSLATION_ELEM_NAME = "translation";
        private static final String MESSAGE_ID_ATT_NAME = "id";
        private static final String PLACEHOLDER_ELEM_NAME = "ph";
        private static final String PLACEHOLDER_NAME_ATT_NAME = "name";
        String lang;
        JsMessage.Builder msgBuilder;

        private Handler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (BUNDLE_ELEM_NAME.equals(qName)) {
                Preconditions.checkState((this.lang == null ? 1 : 0) != 0);
                this.lang = atts.getValue(LANG_ATT_NAME);
                Preconditions.checkState((this.lang != null && !this.lang.isEmpty() ? 1 : 0) != 0);
            } else if (TRANSLATION_ELEM_NAME.equals(qName)) {
                Preconditions.checkState((this.msgBuilder == null ? 1 : 0) != 0);
                String id = atts.getValue(MESSAGE_ID_ATT_NAME);
                Preconditions.checkState((id != null && !id.isEmpty() ? 1 : 0) != 0);
                this.msgBuilder = new JsMessage.Builder(id);
            } else if (PLACEHOLDER_ELEM_NAME.equals(qName)) {
                Preconditions.checkState((this.msgBuilder != null ? 1 : 0) != 0);
                String phRef = atts.getValue(PLACEHOLDER_NAME_ATT_NAME);
                phRef = JsMessageVisitor.toLowerCamelCaseWithNumericSuffixes(phRef);
                this.msgBuilder.appendPlaceholderReference(phRef);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (TRANSLATION_ELEM_NAME.equals(qName)) {
                Preconditions.checkState((this.msgBuilder != null ? 1 : 0) != 0);
                if (!this.msgBuilder.hasParts()) {
                    this.msgBuilder.appendStringPart("");
                }
                String key = this.msgBuilder.getKey();
                XtbMessageBundle.this.messages.put(key, this.msgBuilder.build());
                this.msgBuilder = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.msgBuilder != null) {
                this.msgBuilder.appendStringPart(String.valueOf(ch, start, length));
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this.msgBuilder != null) {
                this.msgBuilder.appendStringPart(String.valueOf(ch, start, length));
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void skippedEntity(String name) {
        }
    }
}

