/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourceRange;
import java.util.ArrayList;
import java.util.Arrays;

public class LineNumberTable {
    private final SourceFile sourceFile;
    private final int[] lineStartOffsets;

    public LineNumberTable(SourceFile sourceFile) {
        this.sourceFile = sourceFile;
        this.lineStartOffsets = LineNumberTable.computeLineStartOffsets(sourceFile.contents);
    }

    private static int[] computeLineStartOffsets(String source) {
        ArrayList<Integer> lineStartOffsets = new ArrayList<Integer>();
        lineStartOffsets.add(0);
        for (int index = 0; index < source.length(); ++index) {
            char ch = source.charAt(index);
            if (!LineNumberTable.isLineTerminator(ch)) continue;
            if (index < source.length() && ch == '\r' && source.charAt(index + 1) == '\n') {
                ++index;
            }
            lineStartOffsets.add(index + 1);
        }
        lineStartOffsets.add(Integer.MAX_VALUE);
        return LineNumberTable.toIntArray(lineStartOffsets);
    }

    public static int[] toIntArray(ArrayList<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    private static boolean isLineTerminator(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    public SourcePosition getSourcePosition(int offset) {
        int line = this.getLine(offset);
        return new SourcePosition(this.sourceFile, offset, line, this.getColumn(line, offset));
    }

    public int getLine(int offset) {
        int index = Arrays.binarySearch(this.lineStartOffsets, offset);
        if (index >= 0) {
            return index;
        }
        return -index - 2;
    }

    public int offsetOfLine(int line) {
        return this.lineStartOffsets[line];
    }

    public int getColumn(int offset) {
        int line = this.getLine(offset);
        return this.getColumn(line, offset);
    }

    private int getColumn(int line, int offset) {
        return offset - this.offsetOfLine(line);
    }

    public SourceRange getSourceRange(int startOffset, int endOffset) {
        return new SourceRange(this.getSourcePosition(startOffset), this.getSourcePosition(endOffset));
    }
}

