/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.ParseTreeVisitor;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.codegeneration.ParseTreeWriter;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.AwaitStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FieldDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForEachStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ModuleDefinitionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TraitDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.YieldStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourceRange;

public class ParseTreeValidator
extends ParseTreeVisitor {
    private ParseTree lastVisited;

    private ParseTreeValidator() {
    }

    public static void validate(ParseTree tree) {
        ParseTreeValidator validator = new ParseTreeValidator();
        try {
            validator.visitAny(tree);
        }
        catch (RuntimeException e) {
            SourceRange location = null;
            if (validator.lastVisited != null) {
                location = validator.lastVisited.location;
            }
            if (location == null) {
                location = tree.location;
            }
            String locationString = location != null ? location.start.toString() : "(unknown)";
            throw new RuntimeException("Parse tree validation failure '" + e.getMessage() + "' at " + locationString + ":\n\n" + ParseTreeWriter.write(tree, validator.lastVisited, true) + "\n", e);
        }
    }

    private void fail(ParseTree tree, String message) {
        if (tree != null) {
            this.lastVisited = tree;
        }
        throw new RuntimeException(message);
    }

    private void check(boolean condition, ParseTree tree, String message) {
        if (!condition) {
            this.fail(tree, message);
        }
    }

    private void checkVisit(boolean condition, ParseTree tree, String message) {
        this.check(condition, tree, message);
        this.visitAny(tree);
    }

    @Override
    protected void visitAny(ParseTree tree) {
        this.lastVisited = tree;
        super.visitAny(tree);
    }

    @Override
    protected void visit(ArgumentListTree tree) {
        for (ParseTree argument : tree.arguments) {
            this.checkVisit(argument.isAssignmentOrSpread(), argument, "assignment or spread expected");
        }
    }

    @Override
    protected void visit(ArrayLiteralExpressionTree tree) {
        for (ParseTree element : tree.elements) {
            this.checkVisit(element.isNull() || element.isAssignmentOrSpread(), element, "assignment or spread expected");
        }
    }

    @Override
    public void visit(ArrayPatternTree tree) {
        int i = 0;
        for (ParseTree element : tree.elements) {
            this.checkVisit(element.isNull() || element.isLeftHandSideExpression() || element.isPattern() || element.isSpreadPatternElement(), element, "null, sub pattern, left hand side expression or spread expected");
            if (element.isSpreadPatternElement()) {
                this.check(i == tree.elements.size() - 1, element, "spread in array patterns must be the last element");
            }
            ++i;
        }
    }

    @Override
    public void visit(AwaitStatementTree tree) {
        this.checkVisit(tree.expression.isExpression(), tree.expression, "async must be expression");
    }

    @Override
    protected void visit(BinaryOperatorTree tree) {
        switch (tree.operator.type) {
            case EQUAL: 
            case STAR_EQUAL: 
            case SLASH_EQUAL: 
            case PERCENT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case LEFT_SHIFT_EQUAL: 
            case RIGHT_SHIFT_EQUAL: 
            case UNSIGNED_RIGHT_SHIFT_EQUAL: 
            case AMPERSAND_EQUAL: 
            case CARET_EQUAL: 
            case BAR_EQUAL: {
                this.check(tree.left.isLeftHandSideExpression() || tree.left.isPattern(), tree.left, "left hand side expression or pattern expected");
                this.check(tree.right.isAssignmentExpression(), tree.right, "assignment expression expected");
                break;
            }
            case AND: 
            case OR: 
            case BAR: 
            case CARET: 
            case AMPERSAND: 
            case EQUAL_EQUAL: 
            case NOT_EQUAL: 
            case EQUAL_EQUAL_EQUAL: 
            case NOT_EQUAL_EQUAL: 
            case OPEN_ANGLE: 
            case CLOSE_ANGLE: 
            case GREATER_EQUAL: 
            case LESS_EQUAL: 
            case INSTANCEOF: 
            case IN: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case PLUS: 
            case MINUS: 
            case STAR: 
            case SLASH: 
            case PERCENT: {
                this.check(tree.left.isAssignmentExpression(), tree.left, "assignment expression expected");
                this.check(tree.right.isAssignmentExpression(), tree.right, "assignment expression expected");
                break;
            }
            default: {
                this.fail(tree, "unexpected binary operator");
            }
        }
        this.visitAny(tree.left);
        this.visitAny(tree.right);
    }

    @Override
    protected void visit(BlockTree tree) {
        for (ParseTree statement : tree.statements) {
            this.checkVisit(statement.isSourceElement(), statement, "statement or function declaration expected");
        }
    }

    @Override
    protected void visit(CallExpressionTree tree) {
        this.check(tree.operand.isLeftHandSideExpression(), tree.operand, "left hand side expression expected");
        if (tree.operand instanceof NewExpressionTree) {
            this.check(tree.operand.asNewExpression().arguments != null, tree.operand, "new arguments expected");
        }
        this.visitAny(tree.operand);
        this.visitAny(tree.arguments);
    }

    @Override
    protected void visit(CaseClauseTree tree) {
        this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
        for (ParseTree statement : tree.statements) {
            this.checkVisit(statement.isStatement(), statement, "statement expected");
        }
    }

    @Override
    protected void visit(CatchTree tree) {
        this.checkVisit(tree.catchBody.type == ParseTreeType.BLOCK, tree.catchBody, "block expected");
    }

    @Override
    protected void visit(ClassDeclarationTree tree) {
        for (ParseTree element : tree.elements) {
            switch (element.type) {
                case FUNCTION_DECLARATION: 
                case GET_ACCESSOR: 
                case SET_ACCESSOR: 
                case MIXIN: 
                case REQUIRES_MEMBER: 
                case FIELD_DECLARATION: {
                    break;
                }
                default: {
                    this.fail(element, "class element expected");
                }
            }
            this.visitAny(element);
        }
    }

    @Override
    protected void visit(CommaExpressionTree tree) {
        for (ParseTree expression : tree.expressions) {
            this.checkVisit(expression.isAssignmentExpression(), expression, "expression expected");
        }
    }

    @Override
    protected void visit(ConditionalExpressionTree tree) {
        this.checkVisit(tree.condition.isAssignmentExpression(), tree.condition, "expression expected");
        this.checkVisit(tree.left.isAssignmentExpression(), tree.left, "expression expected");
        this.checkVisit(tree.right.isAssignmentExpression(), tree.right, "expression expected");
    }

    @Override
    protected void visit(DefaultClauseTree tree) {
        for (ParseTree statement : tree.statements) {
            this.checkVisit(statement.isStatement(), statement, "statement expected");
        }
    }

    @Override
    protected void visit(DoWhileStatementTree tree) {
        this.checkVisit(tree.body.isStatement(), tree.body, "statement expected");
        this.checkVisit(tree.condition.isExpression(), tree.condition, "expression expected");
    }

    @Override
    protected void visit(ExportDeclarationTree tree) {
        switch (tree.type) {
            case FUNCTION_DECLARATION: 
            case VARIABLE_STATEMENT: 
            case MODULE_DEFINITION: 
            case CLASS_DECLARATION: 
            case TRAIT_DECLARATION: {
                break;
            }
            default: {
                this.fail(tree.declaration, "expected valid export tree");
            }
        }
        this.visitAny(tree.declaration);
    }

    @Override
    protected void visit(ExpressionStatementTree tree) {
        this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
    }

    @Override
    protected void visit(FieldDeclarationTree tree) {
        for (VariableDeclarationTree declaration : tree.declarations) {
            this.checkVisit(declaration.type == ParseTreeType.VARIABLE_DECLARATION, declaration, "variable declaration expected");
        }
    }

    @Override
    protected void visit(FinallyTree tree) {
        this.checkVisit(tree.block.type == ParseTreeType.BLOCK, tree.block, "block expected");
    }

    @Override
    protected void visit(ForEachStatementTree tree) {
        this.checkVisit(tree.initializer.declarations.size() <= 1, tree.initializer, "for-each statement may not have more than one variable declaration");
        this.checkVisit(tree.collection.isExpression(), tree.collection, "expression expected");
        this.checkVisit(tree.body.isStatement(), tree.body, "statement expected");
    }

    @Override
    protected void visit(ForInStatementTree tree) {
        if (tree.initializer.type == ParseTreeType.VARIABLE_DECLARATION_LIST) {
            this.checkVisit(tree.initializer.asVariableDeclarationList().declarations.size() <= 1, tree.initializer, "for-in statement may not have more than one variable declaration");
        } else {
            this.checkVisit(tree.initializer.isExpression(), tree.initializer, "variable declaration or expression expected");
        }
        this.checkVisit(tree.collection.isExpression(), tree.collection, "expression expected");
        this.checkVisit(tree.body.isStatement(), tree.body, "statement expected");
    }

    @Override
    protected void visit(FormalParameterListTree tree) {
        for (int i = 0; i < tree.parameters.size(); ++i) {
            ParseTree parameter = (ParseTree)tree.parameters.get(i);
            switch (parameter.type) {
                case REST_PARAMETER: {
                    this.checkVisit(i == tree.parameters.size() - 1, parameter, "rest parameters must be the last parameter in a parameter list");
                }
                case IDENTIFIER_EXPRESSION: {
                    break;
                }
                case DEFAULT_PARAMETER: {
                    break;
                }
                default: {
                    this.fail(parameter, "parameters must be identifiers or rest parameters");
                }
            }
            this.visitAny(parameter);
        }
    }

    @Override
    protected void visit(ForStatementTree tree) {
        if (tree.initializer != null && !tree.initializer.isNull()) {
            this.checkVisit(tree.initializer.isExpression() || tree.initializer.type == ParseTreeType.VARIABLE_DECLARATION_LIST, tree.initializer, "variable declaration list or expression expected");
        }
        if (tree.condition != null) {
            this.checkVisit(tree.condition.isExpression(), tree.condition, "expression expected");
        }
        if (tree.increment != null) {
            this.checkVisit(tree.condition.isExpression(), tree.increment, "expression expected");
        }
        this.checkVisit(tree.body.isStatement(), tree.body, "statement expected");
    }

    @Override
    protected void visit(GetAccessorTree tree) {
        this.checkVisit(tree.body.type == ParseTreeType.BLOCK, tree.body, "block expected");
    }

    @Override
    protected void visit(IfStatementTree tree) {
        this.checkVisit(tree.condition.isExpression(), tree.condition, "expression expected");
        this.checkVisit(tree.ifClause.isStatement(), tree.ifClause, "statement expected");
        if (tree.elseClause != null) {
            this.checkVisit(tree.elseClause.isStatement(), tree.elseClause, "statement expected");
        }
    }

    @Override
    protected void visit(LabelledStatementTree tree) {
        this.checkVisit(tree.statement.isStatement(), tree.statement, "statement expected");
    }

    @Override
    protected void visit(MemberExpressionTree tree) {
        this.check(tree.operand.isMemberExpression(), tree.operand, "member expression expected");
        if (tree.operand instanceof NewExpressionTree) {
            this.check(tree.operand.asNewExpression().arguments != null, tree.operand, "new arguments expected");
        }
        this.visitAny(tree.operand);
    }

    @Override
    protected void visit(MemberLookupExpressionTree tree) {
        this.check(tree.operand.isLeftHandSideExpression(), tree.operand, "left hand side expression expected");
        if (tree.operand instanceof NewExpressionTree) {
            this.check(tree.operand.asNewExpression().arguments != null, tree.operand, "new arguments expected");
        }
        this.visitAny(tree.operand);
    }

    @Override
    protected void visit(MissingPrimaryExpressionTree tree) {
        this.fail(tree, "parse tree contains errors");
    }

    @Override
    protected void visit(MixinResolveListTree tree) {
        for (ParseTree resolve : tree.resolves) {
            this.check(resolve.type == ParseTreeType.MIXIN_RESOLVE, resolve, "mixin resolve expected");
        }
    }

    @Override
    protected void visit(ModuleDefinitionTree tree) {
        for (ParseTree element : tree.elements) {
            this.check(element.isStatement() && element.type != ParseTreeType.BLOCK || element.type == ParseTreeType.CLASS_DECLARATION || element.type == ParseTreeType.EXPORT_DECLARATION || element.type == ParseTreeType.IMPORT_DECLARATION || element.type == ParseTreeType.MODULE_DEFINITION || element.type == ParseTreeType.TRAIT_DECLARATION, element, "module element expected");
        }
    }

    @Override
    protected void visit(NewExpressionTree tree) {
        this.checkVisit(tree.operand.isLeftHandSideExpression(), tree.operand, "left hand side expression expected");
        this.visitAny(tree.arguments);
    }

    @Override
    protected void visit(ObjectLiteralExpressionTree tree) {
        for (ParseTree propertyNameAndValue : tree.propertyNameAndValues) {
            switch (propertyNameAndValue.type) {
                case GET_ACCESSOR: 
                case SET_ACCESSOR: 
                case PROPERTY_NAME_ASSIGNMENT: {
                    break;
                }
                default: {
                    this.fail(propertyNameAndValue, "accessor or property name assignment expected");
                }
            }
            this.visitAny(propertyNameAndValue);
        }
    }

    @Override
    protected void visit(ObjectPatternTree tree) {
        for (ParseTree field : tree.fields) {
            this.checkVisit(field.type == ParseTreeType.OBJECT_PATTERN_FIELD, field, "object pattern field expected");
        }
    }

    @Override
    protected void visit(ObjectPatternFieldTree tree) {
        if (tree.element != null) {
            this.checkVisit(tree.element.isLeftHandSideExpression() || tree.element.isPattern(), tree.element, "left hand side expression or pattern expected");
        }
    }

    @Override
    protected void visit(ParenExpressionTree tree) {
        if (tree.expression.isPattern()) {
            this.visitAny(tree.expression);
        } else {
            this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
        }
    }

    @Override
    protected void visit(PostfixExpressionTree tree) {
        this.checkVisit(tree.operand.isAssignmentExpression(), tree.operand, "assignment expression expected");
    }

    @Override
    protected void visit(ProgramTree tree) {
        for (ParseTree sourceElement : tree.sourceElements) {
            this.checkVisit(sourceElement.isSourceElement() || sourceElement.type == ParseTreeType.CLASS_DECLARATION || sourceElement.type == ParseTreeType.TRAIT_DECLARATION || sourceElement.type == ParseTreeType.MODULE_DEFINITION, sourceElement, "global source element expected");
        }
    }

    @Override
    protected void visit(PropertyNameAssignmentTree tree) {
        this.checkVisit(tree.value.isAssignmentExpression(), tree.value, "assignment expression expected");
    }

    @Override
    protected void visit(ReturnStatementTree tree) {
        if (tree.expression != null) {
            this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
        }
    }

    @Override
    protected void visit(SetAccessorTree tree) {
        this.checkVisit(tree.body.type == ParseTreeType.BLOCK, tree.body, "block expected");
    }

    @Override
    protected void visit(SpreadExpressionTree tree) {
        this.checkVisit(tree.expression.isAssignmentExpression(), tree.expression, "assignment expression expected");
    }

    @Override
    protected void visit(SwitchStatementTree tree) {
        this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
        int defaultCount = 0;
        for (ParseTree caseClause : tree.caseClauses) {
            if (caseClause.type == ParseTreeType.DEFAULT_CLAUSE) {
                this.checkVisit(++defaultCount <= 1, caseClause, "no more than one default clause allowed");
                continue;
            }
            this.checkVisit(caseClause.type == ParseTreeType.CASE_CLAUSE, caseClause, "case or default clause expected");
        }
    }

    @Override
    protected void visit(TraitDeclarationTree tree) {
        for (ParseTree element : tree.elements) {
            switch (element.type) {
                case FUNCTION_DECLARATION: 
                case GET_ACCESSOR: 
                case SET_ACCESSOR: 
                case MIXIN: 
                case REQUIRES_MEMBER: {
                    break;
                }
                default: {
                    this.fail(element, "trait element expected");
                }
            }
            this.visitAny(element);
        }
    }

    @Override
    protected void visit(ThrowStatementTree tree) {
        if (tree.value == null) {
            return;
        }
        this.checkVisit(tree.value.isExpression(), tree.value, "expression expected");
    }

    @Override
    protected void visit(TryStatementTree tree) {
        this.checkVisit(tree.body.type == ParseTreeType.BLOCK, tree.body, "block expected");
        if (tree.catchBlock != null && !tree.catchBlock.isNull()) {
            this.checkVisit(tree.catchBlock.type == ParseTreeType.CATCH, tree.catchBlock, "catch block expected");
        }
        if (tree.finallyBlock != null && !tree.finallyBlock.isNull()) {
            this.checkVisit(tree.finallyBlock.type == ParseTreeType.FINALLY, tree.finallyBlock, "finally block expected");
        }
        if ((tree.catchBlock == null || tree.catchBlock.isNull()) && (tree.finallyBlock == null || tree.finallyBlock.isNull())) {
            this.fail(tree, "either catch or finally must be present");
        }
    }

    @Override
    protected void visit(UnaryExpressionTree tree) {
        this.checkVisit(tree.operand.isAssignmentExpression(), tree.operand, "assignment expression expected");
    }

    @Override
    protected void visit(VariableDeclarationTree tree) {
        if (tree.initializer != null) {
            this.checkVisit(tree.initializer.isAssignmentExpression(), tree.initializer, "assignment expression expected");
        }
    }

    @Override
    protected void visit(WhileStatementTree tree) {
        this.checkVisit(tree.condition.isExpression(), tree.condition, "expression expected");
        this.checkVisit(tree.body.isStatement(), tree.body, "statement expected");
    }

    @Override
    protected void visit(WithStatementTree tree) {
        this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
        this.checkVisit(tree.body.isStatement(), tree.body, "statement expected");
    }

    @Override
    protected void visit(YieldStatementTree tree) {
        if (tree.expression != null) {
            this.checkVisit(tree.expression.isExpression(), tree.expression, "expression expected");
        }
    }
}

