/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.io.PrintStream;
import java.util.HashMap;

public class Timer {
    private final String name;
    private final long start;
    private static final HashMap<String, Entry> entries = new HashMap();

    public Timer(String name) {
        this.name = name;
        this.start = this.getCurrentTime();
    }

    public void end() {
        Timer.logTime(this.name, this.getCurrentTime() - this.start);
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static void logTime(String name, long elapsedTime) {
        Entry entry = Timer.getEntry(name);
        ++entry.count;
        entry.elapsedTime += elapsedTime;
    }

    private static Entry getEntry(String name) {
        Entry entry;
        if (!entries.containsKey(name)) {
            entry = new Entry(name);
            entries.put(name, entry);
        } else {
            entry = entries.get(name);
        }
        return entry;
    }

    public static Iterable<Entry> getEntries() {
        return entries.values();
    }

    public static void clearEntries() {
        entries.clear();
    }

    public static void dumpEntries(PrintStream out) {
        for (Entry entry : Timer.getEntries()) {
            out.println(SimpleFormat.format("Time '%s'(%d): %fms", entry.name, entry.count, (double)entry.elapsedTime / 1000.0));
        }
        Timer.clearEntries();
    }

    public static class Entry {
        public final String name;
        public int count;
        public long elapsedTime;

        public Entry(String name) {
            this.name = name;
        }
    }
}

