/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.head.serialize;

import com.google.gwt.thirdparty.javascript.rhino.head.Context;
import com.google.gwt.thirdparty.javascript.rhino.head.Scriptable;
import com.google.gwt.thirdparty.javascript.rhino.head.Undefined;
import com.google.gwt.thirdparty.javascript.rhino.head.UniqueTag;
import com.google.gwt.thirdparty.javascript.rhino.head.serialize.ScriptableOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptableInputStream
extends ObjectInputStream {
    private Scriptable scope;
    private ClassLoader classLoader;

    public ScriptableInputStream(InputStream in, Scriptable scope) throws IOException {
        super(in);
        this.scope = scope;
        this.enableResolveObject(true);
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            this.classLoader = cx.getApplicationClassLoader();
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if (this.classLoader != null) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.resolveClass(desc);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof ScriptableOutputStream.PendingLookup) {
            String name = ((ScriptableOutputStream.PendingLookup)obj).getName();
            if ((obj = ScriptableOutputStream.lookupQualifiedName(this.scope, name)) == Scriptable.NOT_FOUND) {
                throw new IOException("Object " + name + " not found upon " + "deserialization.");
            }
        } else if (obj instanceof UniqueTag) {
            obj = ((UniqueTag)obj).readResolve();
        } else if (obj instanceof Undefined) {
            obj = ((Undefined)obj).readResolve();
        }
        return obj;
    }
}

