/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client;

import java.util.HashMap;
import java.util.Map;

/**
 * Abstract class mapping between {@link ComponentConnector} instances and their
 * instances.
 *
 * A concrete implementation of this class is generated by WidgetMapGenerator or
 * one of its subclasses during widgetset compilation.
 */
abstract class WidgetMap {

    protected static Map<Class<? extends ServerConnector>, WidgetInstantiator> instmap = new HashMap<>();

    /**
     * Create a new instance of a connector based on its type.
     *
     * @param classType
     *            {@link ComponentConnector} class to instantiate
     * @return new instance of the connector
     */
    public ServerConnector instantiate(
            Class<? extends ServerConnector> classType) {
        return instmap.get(classType).get();
    }

    /**
     * Return the connector class to use for a fully qualified server side
     * component class name.
     *
     * @param fullyqualifiedName
     *            fully qualified name of the server side component class
     * @return component connector class to use
     */
    public abstract Class<? extends ServerConnector> getConnectorClassForServerSideClassName(
            String fullyqualifiedName);

    /**
     * Return the connector classes to load after the initial widgetset load and
     * start.
     *
     * @return component connector class to load after the initial widgetset
     *         loading
     */
    public abstract Class<? extends ServerConnector>[] getDeferredLoadedConnectors();

    /**
     * Make sure the code for a (deferred or lazy) component connector type has
     * been loaded, triggering the load and waiting for its completion if
     * necessary.
     *
     * @param classType
     *            component connector class
     */
    public abstract void ensureInstantiator(
            Class<? extends ServerConnector> classType);

}
