/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.event;

import com.google.gwt.event.shared.EventHandler;

/**
 * Handler interface for {@link InputEvent}s.
 *
 * @since 8.0
 */
public interface InputHandler extends EventHandler {

    /**
     * Called when an {@link InputEvent} is fired.
     *
     * @param event
     *            the {@link InputEvent} that was fired.
     */
    void onInput(InputEvent event);
}
