/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.twincolselect;

import com.vaadin.client.DirectionalManagedLayout;
import com.vaadin.client.annotations.OnStateChange;
import com.vaadin.client.connectors.AbstractMultiSelectConnector;
import com.vaadin.client.ui.VTwinColSelect;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.twincolselect.TwinColSelectState;
import com.vaadin.ui.TwinColSelect;

/**
 * Client side connector for {@link TwinColSelect} component.
 *
 * @author Vaadin Ltd
 *
 */
@Connect(TwinColSelect.class)
public class TwinColSelectConnector extends AbstractMultiSelectConnector
        implements DirectionalManagedLayout {

    @Override
    protected void init() {
        super.init();
        getLayoutManager().registerDependency(this,
                getWidget().getCaptionWrapper().getElement());
    }

    @Override
    public void onUnregister() {
        getLayoutManager().unregisterDependency(this,
                getWidget().getCaptionWrapper().getElement());
    }

    @Override
    public VTwinColSelect getWidget() {
        return (VTwinColSelect) super.getWidget();
    }

    @Override
    public TwinColSelectState getState() {
        return (TwinColSelectState) super.getState();
    }

    @OnStateChange(value = { "leftColumnCaption", "rightColumnCaption",
            "caption" })
    void updateCaptions() {
        getWidget().updateCaptions(getState().leftColumnCaption,
                getState().rightColumnCaption);

        getLayoutManager().setNeedsHorizontalLayout(this);
    }

    @OnStateChange("readOnly")
    void updateReadOnly() {
        getWidget().setReadOnly(isReadOnly());
    }

    @OnStateChange("tabIndex")
    void updateTabIndex() {
        getWidget().setTabIndex(getState().tabIndex);
    }

    @Override
    public void layoutVertically() {
        if (isUndefinedHeight()) {
            getWidget().clearInternalHeights();
        } else {
            getWidget().setInternalHeights();
        }
    }

    @Override
    public void layoutHorizontally() {
        if (isUndefinedWidth()) {
            getWidget().clearInternalWidths();
        } else {
            getWidget().setInternalWidths();
        }
    }

    @Override
    public MultiSelectWidget getMultiSelectWidget() {
        return getWidget();
    }
}
