/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.grid.events;

import com.google.gwt.event.shared.EventHandler;
import com.vaadin.client.widgets.Grid.AbstractGridMouseEvent;

/**
 * Base interface of all handlers for {@link AbstractGridMouseEvent}s.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public abstract interface AbstractGridMouseEventHandler extends EventHandler {

    /**
     * Handler for Grid click events.
     */
    public abstract interface GridClickHandler
            extends AbstractGridMouseEventHandler {
        /**
         * Perform actions that should happen when the Grid is clicked.
         *
         * @param event
         *            the click event
         */
        public void onClick(GridClickEvent event);
    }

    /**
     * Handler for Grid double-click events.
     */
    public abstract interface GridDoubleClickHandler
            extends AbstractGridMouseEventHandler {
        /**
         * Perform actions that should happen when the Grid is double-clicked.
         *
         * @param event
         *            the double-click event
         */
        public void onDoubleClick(GridDoubleClickEvent event);
    }

}
