/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.treegrid.events;

import com.google.gwt.dom.client.BrowserEvents;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.vaadin.client.WidgetUtil;
import com.vaadin.client.renderers.HierarchyRenderer;
import com.vaadin.client.widget.grid.events.AbstractGridMouseEventHandler.GridDoubleClickHandler;
import com.vaadin.client.widget.grid.events.GridDoubleClickEvent;
import com.vaadin.client.widget.treegrid.TreeGrid;
import com.vaadin.client.widgets.Grid;

/**
 * Represents native mouse double click event in TreeGrid.
 * <p>
 * Differs from {@link GridDoubleClickEvent} only in allowing events to
 * originate form hierarchy widget.
 *
 * @author Vaadin Ltd
 * @since 8.2
 */
public class TreeGridDoubleClickEvent extends GridDoubleClickEvent {

    /** DOM event type. */
    public static final Type<GridDoubleClickHandler> TYPE = new Type<>(
            BrowserEvents.DBLCLICK, new TreeGridDoubleClickEvent());

    @Override
    public Type<GridDoubleClickHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    public TreeGrid getGrid() {
        EventTarget target = getNativeEvent().getEventTarget();
        if (!Element.is(target)) {
            return null;
        }
        return WidgetUtil.findWidget(Element.as(target), TreeGrid.class, false);
    }

    @Override
    protected boolean ignoreEventFromTarget(Grid<?> grid,
            Element targetElement) {
        // Do not ignore when element is in hierarchy renderer
        return super.ignoreEventFromTarget(grid, targetElement)
                && !HierarchyRenderer.isElementInHierarchyWidget(targetElement);
    }
}
