/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.grid;

import com.vaadin.client.renderers.ProgressBarRenderer;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.grid.renderers.ProgressBarRendererState;

/**
 * A connector for {@link ProgressBarRenderer}.
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
@Connect(com.vaadin.ui.renderers.ProgressBarRenderer.class)
public class ProgressBarRendererConnector
        extends AbstractGridRendererConnector<Double> {

    @Override
    public ProgressBarRenderer getRenderer() {
        return (ProgressBarRenderer) super.getRenderer();
    }

    @Override
    public ProgressBarRendererState getState() {
        return (ProgressBarRendererState) super.getState();
    }
}
