/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.grid;

import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.treegrid.TreeGridDragSourceState;
import com.vaadin.ui.components.grid.TreeGridDragSource;

/**
 * Adds HTML5 drag and drop functionality to a TreeGrid's rows. This is the
 * client side counterpart of {@link TreeGridDragSource}.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
@Connect(TreeGridDragSource.class)
public class TreeGridDragSourceConnector extends GridDragSourceConnector {

    @Override
    public TreeGridDragSourceState getState() {
        return (TreeGridDragSourceState) super.getState();
    }

}
