/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.event;

import com.google.gwt.event.dom.client.DomEvent;

/**
 * Represents a native InputEvent.
 *
 * @since 8.0
 */
public class InputEvent extends DomEvent<InputHandler> {

    /**
     * Event type for InputEvent. Represents the meta-data associated with this
     * event.
     */
    private static final Type<InputHandler> TYPE = new Type<>("input",
            new InputEvent());

    protected InputEvent() {
    }

    /**
     * Gets the event type associated with InputEvent.
     *
     * @return the handler type
     */
    public static Type<InputHandler> getType() {
        return TYPE;
    }

    @Override
    public Type<InputHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(InputHandler handler) {
        handler.onInput(this);
    }
}
