/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors;

import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.client.ui.ConnectorFocusAndBlurHandler;

/**
 * Abstract class for listing widget connectors that contains focusable children
 * to track their focus/blur events.
 *
 * @author Vaadin Ltd
 *
 * @param <WIDGET>
 *            widget type which has to allow to register focus/blur handlers
 * @since 8.0
 */
public abstract class AbstractFocusableListingConnector<WIDGET extends Widget & HasAllFocusHandlers>
        extends AbstractListingConnector {

    private ConnectorFocusAndBlurHandler handler;

    @Override
    protected void init() {
        handler = ConnectorFocusAndBlurHandler.addHandlers(this);
    }

    @Override
    public void onUnregister() {
        super.onUnregister();
        handler.removeHandlers();
        handler = null;
    }

    @SuppressWarnings("unchecked")
    @Override
    public WIDGET getWidget() {
        return (WIDGET) super.getWidget();
    }
}
