/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui;

import com.vaadin.client.ComponentConnector;

/**
 * Implemented by connectors supporting a required flag.
 *
 * @since 8.0
 */
public interface HasRequiredIndicator extends ComponentConnector {

    /**
     * Checks if a required indicator should be shown for the given connector.
     *
     * @return <code>true</code> to show an indicator, <code>false</code>
     *         otherwise
     */
    boolean isRequiredIndicatorVisible();

}
