/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.grid.selection;

import com.vaadin.client.renderers.Renderer;

/**
 * Interface for SelectionModels that wants Grid to display a selection column.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @see Renderer
 */
public interface SelectionModelWithSelectionColumn {

    /**
     * Returns a new instance of the Renderer for selection column.
     *
     * @return selection column renderer
     */
    public Renderer<Boolean> getRenderer();

}
