/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.dd;

import com.vaadin.client.ComponentConnector;
import com.vaadin.client.extensions.DropTargetExtensionConnector;

/**
 * Used to detect Widget from widget tree that has {@link #getDropHandler()}
 *
 * Decide whether to get rid of this class. If so, {@link VAbstractDropHandler}
 * must extend {@link ComponentConnector}.
 *
 * @author Vaadin Ltd
 * @deprecated Replaced in 8.1 with {@link DropTargetExtensionConnector}
 */
@Deprecated
public interface VHasDropHandler {
    /**
     * Returns the drop handler for this widget.
     *
     * @return the drop handler
     */
    public VDropHandler getDropHandler();
}
