/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.dd;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * Wrapper for html5 File object.
 *
 * @author Vaadin Ltd
 * @deprecated Since 8.1, will be replaced by FileDropTargetExtensionConnector
 *             and FileDropTargetExtension,
 *             https://github.com/vaadin/framework/issues/8891
 */
@Deprecated
public class VHtml5File extends JavaScriptObject {

    /** Singleton. */
    protected VHtml5File() {
    }

    /**
     * Returns the name value.
     *
     * @return the name
     */
    public final native String getName()
    /*-{
        return this.name;
     }-*/;

    /**
     * Returns the type value.
     *
     * @return the type
     */
    public final native String getType()
    /*-{
        return this.type;
     }-*/;

    /**
     * Browser implementations support files >2GB dropped and report the value
     * as long. Due to JSNI limitations this value needs to be sent as double
     * and then cast back to a long value.
     * www.gwtproject.org/doc/latest/DevGuideCodingBasicsJSNI.html#important
     *
     * @return the size
     */
    public final native double getSize()
    /*-{
        return this.size ? this.size : 0;
    }-*/;

}
