/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.datefield;

import java.util.Date;

import com.vaadin.client.DateTimeService;
import com.vaadin.client.ui.VDateTimeCalendarPanel;
import com.vaadin.client.ui.VDateTimeFieldCalendar;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.ui.InlineDateTimeField;

/**
 * The client-side connector for InlineDateTimeField.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
@Connect(InlineDateTimeField.class)
public class InlineDateTimeFieldConnector extends
        AbstractInlineDateFieldConnector<VDateTimeCalendarPanel, DateTimeResolution> {

    @Override
    protected boolean isResolutionMonthOrHigher() {
        return getWidget().getCurrentResolution()
                .compareTo(DateTimeResolution.MONTH) >= 0;
    }

    @Override
    public VDateTimeFieldCalendar getWidget() {
        return (VDateTimeFieldCalendar) super.getWidget();
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void updateListeners() {
        super.updateListeners();
        if (getWidget().getCurrentResolution()
                .compareTo(DateTimeResolution.DAY) < 0) {
            getWidget().calendarPanel
                    .setTimeChangeListener((hour, min, sec, msec) -> {
                        Date d = getWidget().getDate();
                        if (d == null) {
                            // date currently null, use the value from
                            // calendarPanel
                            // (~ client time at the init of the widget)
                            d = (Date) getWidget().calendarPanel.getDate()
                                    .clone();
                        }
                        d.setHours(hour);
                        d.setMinutes(min);
                        d.setSeconds(sec);
                        DateTimeService.setMilliseconds(d, msec);

                        // Always update time changes to the server
                        getWidget().calendarPanel.setDate(d);
                        getWidget().updateValueFromPanel();
                    });
        }
    }
}
