/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.grid.events;

import com.google.gwt.event.shared.EventHandler;
import com.vaadin.client.widgets.Grid.AbstractGridKeyEvent;

/**
 * Base interface of all handlers for {@link AbstractGridKeyEvent}s.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public abstract interface AbstractGridKeyEventHandler extends EventHandler {

    /**
     * Handler for Grid key down events.
     */
    public abstract interface GridKeyDownHandler
            extends AbstractGridKeyEventHandler {
        /**
         * Perform actions that should happen when a key down event is triggered
         * within a Grid.
         *
         * @param event
         *            the key down event
         */
        public void onKeyDown(GridKeyDownEvent event);
    }

    /**
     * Handler for Grid key up events.
     */
    public abstract interface GridKeyUpHandler
            extends AbstractGridKeyEventHandler {
        /**
         * Perform actions that should happen when a key up event is triggered
         * within a Grid.
         *
         * @param event
         *            the key up event
         */
        public void onKeyUp(GridKeyUpEvent event);
    }

    /**
     * Handler for Grid key press events.
     */
    public abstract interface GridKeyPressHandler
            extends AbstractGridKeyEventHandler {
        /**
         * Perform actions that should happen when a key press event is
         * triggered within a Grid.
         *
         * @param event
         *            the key press event
         */
        public void onKeyPress(GridKeyPressEvent event);
    }

}
