/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.dd;

import com.vaadin.client.UIDL;
import com.vaadin.ui.dnd.DropTargetExtension;

/**
 *
 * @author Vaadin Ltd
 * @deprecated Replaced in 8.1 with
 *             {@link DropTargetExtension#setDropCriteria(String)}
 *
 */
@Deprecated
public abstract class VAcceptCriterion {

    /**
     * Checks if current drag event has valid drop target and target accepts the
     * transferable. If drop target is valid, callback is used.
     *
     * @param drag
     *            the drag event
     * @param configuration
     *            accept criterion UIDL
     * @param callback
     *            the callback that handles acceptance if the target is valid
     */
    public void accept(final VDragEvent drag, UIDL configuration,
            final VAcceptCallback callback) {
        if (needsServerSideCheck(drag, configuration)) {
            VDragEventServerCallback acceptCallback = (accepted, response) -> {
                if (accepted) {
                    callback.accepted(drag);
                }
            };
            VDragAndDropManager.get().visitServer(acceptCallback);
        } else {
            boolean validates = accept(drag, configuration);
            if (validates) {
                callback.accepted(drag);
            }
        }
    }

    /**
     * Returns whether a client-side check accepts the drop attempt.
     *
     * @param drag
     *            the drag event
     * @param configuration
     *            accept criterion UIDL
     * @return {@code true} if a drop attempt is accepted, {@code false}
     *         otherwise
     */
    protected abstract boolean accept(VDragEvent drag, UIDL configuration);

    /**
     * Returns whether a server side check is needed for determining acceptance.
     *
     * @param drag
     *            the drag event
     * @param criterioUIDL
     *            accept criterion UIDL
     * @return {@code true} if a server side check is needed, {@code false}
     *         otherwise
     */
    public boolean needsServerSideCheck(VDragEvent drag, UIDL criterioUIDL) {
        return false;
    }

}
