/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors;

import com.google.gwt.event.shared.HandlerRegistration;
import com.vaadin.client.MouseEventDetailsBuilder;
import com.vaadin.client.connectors.grid.AbstractGridRendererConnector;
import com.vaadin.client.renderers.ClickableRenderer.RendererClickEvent;
import com.vaadin.client.renderers.ClickableRenderer.RendererClickHandler;
import com.vaadin.shared.ui.grid.renderers.ClickableRendererState;
import com.vaadin.shared.ui.grid.renderers.RendererClickRpc;

import elemental.json.JsonObject;

/**
 * An abstract base class for
 * {@link com.vaadin.client.renderers.ClickableRenderer ClickableRenderer}
 * connectors.
 *
 * @param <T>
 *            the presentation type of the renderer
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public abstract class ClickableRendererConnector<T>
        extends AbstractGridRendererConnector<T> {

    private HandlerRegistration clickRegistration;

    @Override
    protected void init() {
        clickRegistration = addClickHandler(
                new RendererClickHandler<JsonObject>() {
                    @Override
                    public void onClick(RendererClickEvent<JsonObject> event) {
                        if (getGridConnector().isReadOnly()) {
                            // NO-OP
                            return;
                        }
                        getRpcProxy(RendererClickRpc.class).click(
                                getRowKey(event.getCell().getRow()),
                                getColumnId(event.getCell().getColumn()),
                                MouseEventDetailsBuilder.buildMouseEventDetails(
                                        event.getNativeEvent()));
                    }
                });
    }

    @Override
    public void onUnregister() {
        clickRegistration.removeHandler();
    }

    protected abstract HandlerRegistration addClickHandler(
            RendererClickHandler<JsonObject> handler);

    @Override
    public ClickableRendererState getState() {
        return (ClickableRendererState) super.getState();
    }
}
