/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.data;

import com.vaadin.client.data.DataSource;

import elemental.json.JsonObject;

/**
 * A marker interface for connectors that have a data source.
 *
 * @author Vaadin Ltd.
 * @see DataSource
 * @since 8.0
 */
public interface HasDataSource {

    /**
     * Sets the data source for this Connector.
     *
     * @param dataSource
     *            the new data source, not null
     */
    void setDataSource(DataSource<JsonObject> dataSource);

    /**
     * Gets the current data source for this Connector.
     *
     * @return the data source, not null
     */
    DataSource<JsonObject> getDataSource();
}
