/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui;

import com.vaadin.shared.ui.datefield.DateResolution;

/**
 * A calendar panel widget to show and select a date.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
public class VDateCalendarPanel extends VAbstractCalendarPanel<DateResolution> {

    @Override
    protected boolean acceptDayFocus() {
        return isDay(getResolution());
    }

    @Override
    protected boolean isDay(DateResolution resolution) {
        return DateResolution.DAY.equals(resolution);
    }

    @Override
    protected boolean isMonth(DateResolution resolution) {
        return DateResolution.MONTH.equals(resolution);
    }

    @Override
    protected boolean isBelowMonth(DateResolution resolution) {
        return isDay(resolution);
    }

}
