/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.treegrid.events;

import com.google.gwt.dom.client.BrowserEvents;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.vaadin.client.WidgetUtil;
import com.vaadin.client.renderers.HierarchyRenderer;
import com.vaadin.client.widget.grid.events.AbstractGridMouseEventHandler.GridClickHandler;
import com.vaadin.client.widget.grid.events.GridClickEvent;
import com.vaadin.client.widget.treegrid.TreeGrid;
import com.vaadin.client.widgets.Grid;

/**
 * Represents native mouse click event in TreeGrid.
 * <p>
 * Differs from {@link GridClickEvent} only in allowing events to originate form
 * hierarchy widget.
 *
 * @since 8.1
 * @author Vaadin Ltd
 */
public class TreeGridClickEvent extends GridClickEvent {

    /** DOM event type. */
    public static final Type<GridClickHandler> TYPE = new Type<GridClickHandler>(
            BrowserEvents.CLICK, new TreeGridClickEvent());

    @Override
    public Type<GridClickHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    public TreeGrid getGrid() {
        EventTarget target = getNativeEvent().getEventTarget();
        if (!Element.is(target)) {
            return null;
        }
        return WidgetUtil.findWidget(Element.as(target), TreeGrid.class, false);
    }

    @Override
    protected boolean ignoreEventFromTarget(Grid<?> grid,
            Element targetElement) {
        // Do not ignore when element is in hierarchy renderer
        return super.ignoreEventFromTarget(grid, targetElement)
                && !HierarchyRenderer.isElementInHierarchyWidget(targetElement);
    }
}
