/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui;

import com.google.gwt.dom.client.Element;

/**
 * Implemented by widgets supporting an error indicator.
 *
 * @since 8.2
 */
public interface HasErrorIndicatorElement {

    /**
     * Gets the error indicator element.
     *
     * @return the error indicator element
     */
    Element getErrorIndicatorElement();

    /**
     * Sets the visibility of the error indicator element.
     *
     * @param visible
     *            {@code true} to show the error indicator element,
     *            {@code false} to hide it
     */
    void setErrorIndicatorElementVisible(boolean visible);
}
