/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.listselect;

import com.vaadin.client.annotations.OnStateChange;
import com.vaadin.client.connectors.AbstractMultiSelectConnector;
import com.vaadin.client.ui.VListSelect;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.listselect.ListSelectState;
import com.vaadin.ui.ListSelect;

/**
 * Client side connector for {@link ListSelect} component.
 *
 * @author Vaadin Ltd
 *
 */
@Connect(ListSelect.class)
public class ListSelectConnector extends AbstractMultiSelectConnector {

    @Override
    public VListSelect getWidget() {
        return (VListSelect) super.getWidget();
    }

    @Override
    public MultiSelectWidget getMultiSelectWidget() {
        return getWidget();
    }

    @Override
    public ListSelectState getState() {
        return (ListSelectState) super.getState();
    }

    @OnStateChange("readOnly")
    void updateReadOnly() {
        getWidget().setReadOnly(isReadOnly());
    }

    @OnStateChange("tabIndex")
    void updateTabIndex() {
        getWidget().setTabIndex(getState().tabIndex);
    }
}
