/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.escalator.events;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event fired when a spacer element is moved to a new index in Escalator.
 *
 * @author Vaadin Ltd
 * @since 8.9
 */
public class SpacerIndexChangedEvent
        extends GwtEvent<SpacerIndexChangedHandler> {

    /**
     * Handler type.
     */
    public static final Type<SpacerIndexChangedHandler> TYPE = new Type<>();

    /**
     * Returns the associated handler type.
     *
     * @return the handler type
     */
    public static final Type<SpacerIndexChangedHandler> getType() {
        return TYPE;
    }

    private final int oldIndex;
    private final int newIndex;

    /**
     * Creates a spacer index changed event.
     *
     * @param oldIndex
     *            old index of row to which the spacer belongs
     * @param newIndex
     *            new index of row to which the spacer belongs
     */
    public SpacerIndexChangedEvent(int oldIndex, int newIndex) {
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
    }

    /**
     * Gets the old row index to which the spacer element belongs.
     *
     * @return the old row index to which the spacer element belongs
     */
    public int getOldIndex() {
        return oldIndex;
    }

    /**
     * Gets the new row index to which the spacer element belongs.
     *
     * @return the new row index to which the spacer element belongs
     */
    public int getNewIndex() {
        return newIndex;
    }

    @Override
    public Type<SpacerIndexChangedHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(SpacerIndexChangedHandler handler) {
        handler.onSpacerIndexChanged(this);
    }

}
