/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors;

import com.vaadin.client.connectors.data.HasDataSource;
import com.vaadin.client.data.DataSource;
import com.vaadin.client.ui.AbstractFieldConnector;
import com.vaadin.shared.data.DataCommunicatorConstants;
import com.vaadin.shared.ui.abstractlisting.AbstractListingState;
import com.vaadin.ui.AbstractListing;

import elemental.json.JsonObject;
import elemental.json.JsonValue;

/**
 * A base connector class for {@link AbstractListing}.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.0
 */
public abstract class AbstractListingConnector extends AbstractFieldConnector
        implements HasDataSource {

    private DataSource<JsonObject> dataSource = null;

    @Override
    public void setDataSource(DataSource<JsonObject> dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataSource<JsonObject> getDataSource() {
        return dataSource;
    }

    /**
     * Returns the key of the given data row.
     *
     * @param row
     *            the row
     * @return the row key
     */
    protected static String getRowKey(JsonObject row) {
        return row.getString(DataCommunicatorConstants.KEY);
    }

    /**
     * Returns the data of the given data row.
     *
     * @param row
     *            the row
     * @return the row data
     */
    protected static JsonValue getRowData(JsonObject row) {
        return row.get(DataCommunicatorConstants.DATA);
    }

    /**
     * Returns whether the given row is selected.
     *
     * @param row
     *            the row
     * @return {@code true} if the row is selected, {@code false} otherwise
     */
    protected boolean isRowSelected(JsonObject row) {
        return row.hasKey(DataCommunicatorConstants.SELECTED);
    }

    @Override
    public AbstractListingState getState() {
        return (AbstractListingState) super.getState();
    }
}
