/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.widget.escalator.events;

import com.google.gwt.event.shared.EventHandler;

/**
 * Event handler for a spacer index changed event.
 *
 * @author Vaadin Ltd
 * @since 8.9
 */
public interface SpacerIndexChangedHandler extends EventHandler {

    /**
     * Called when a spacer index changed event is fired, when a spacer's index
     * changes.
     *
     * @param event
     *            the spacer index changed event
     */
    public void onSpacerIndexChanged(SpacerIndexChangedEvent event);
}
