/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class ComboBoxRenderManager<TItem>
implements Serializable {
    private final ComboBoxBase<?, TItem, ?> comboBox;
    private Renderer<TItem> renderer;
    private boolean renderScheduled;
    private final List<Registration> renderingRegistrations = new ArrayList<Registration>();
    private Element template;

    ComboBoxRenderManager(ComboBoxBase<?, TItem, ?> comboBox) {
        this.comboBox = comboBox;
    }

    void setRenderer(Renderer<TItem> renderer) {
        Objects.requireNonNull(renderer, "The renderer must not be null");
        this.renderer = renderer;
        this.scheduleRender();
    }

    void scheduleRender() {
        if (this.renderScheduled || this.comboBox.getDataCommunicator() == null || this.renderer == null) {
            return;
        }
        this.renderScheduled = true;
        this.comboBox.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.render();
            this.renderScheduled = false;
        });
    }

    private void render() {
        Rendering rendering;
        this.renderingRegistrations.forEach(Registration::remove);
        this.renderingRegistrations.clear();
        if (this.renderer instanceof LitRenderer) {
            if (this.template != null && this.template.getParent() != null) {
                this.comboBox.getElement().removeChild(new Element[]{this.template});
            }
            rendering = this.renderer.render(this.comboBox.getElement(), this.comboBox.getDataCommunicator().getKeyMapper());
        } else {
            if (this.template == null) {
                this.template = new Element("template");
            }
            if (this.template.getParent() == null) {
                this.comboBox.getElement().appendChild(new Element[]{this.template});
            }
            rendering = this.renderer.render(this.comboBox.getElement(), this.comboBox.getDataCommunicator().getKeyMapper(), this.template);
        }
        rendering.getDataGenerator().ifPresent(renderingDataGenerator -> {
            Registration renderingDataGeneratorRegistration = this.comboBox.getDataGenerator().addDataGenerator(renderingDataGenerator);
            this.renderingRegistrations.add(renderingDataGeneratorRegistration);
        });
        this.renderingRegistrations.add(rendering.getRegistration());
        this.comboBox.getDataController().reset();
    }
}

