/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class MultiSelectComboBoxSelectionModel<TItem>
implements Serializable {
    private Map<Object, TItem> selection = new LinkedHashMap<Object, TItem>();
    private SerializableFunction<TItem, Object> identityProvider;

    MultiSelectComboBoxSelectionModel(SerializableFunction<TItem, Object> identityProvider) {
        this.identityProvider = identityProvider;
    }

    Set<TItem> getSelectedItems() {
        return Collections.unmodifiableSet(new LinkedHashSet<TItem>(this.selection.values()));
    }

    boolean setSelectedItems(Set<TItem> items) {
        Map<Object, TItem> newSelectionMap = this.mapItemsById(items);
        if (!newSelectionMap.keySet().equals(this.selection.keySet())) {
            this.selection = newSelectionMap;
            return true;
        }
        return false;
    }

    public void setIdentityProvider(SerializableFunction<TItem, Object> identityProvider) {
        this.identityProvider = identityProvider;
        this.selection = this.mapItemsById(new LinkedHashSet<TItem>(this.selection.values()));
    }

    boolean isSelected(TItem item) {
        return this.selection.containsKey(this.identityProvider.apply(item));
    }

    boolean updateSelection(Set<TItem> addedItems, Set<TItem> removedItems) {
        return this.doUpdateSelection(this.mapItemsById(addedItems), this.mapItemsById(removedItems));
    }

    private boolean doUpdateSelection(Map<Object, TItem> addedItems, Map<Object, TItem> removedItems) {
        if (this.selection.keySet().containsAll(addedItems.keySet()) && Collections.disjoint(this.selection.keySet(), removedItems.keySet())) {
            return false;
        }
        new LinkedHashMap<Object, TItem>(removedItems).forEach(this.selection::remove);
        this.selection.putAll(addedItems);
        return true;
    }

    private Map<Object, TItem> mapItemsById(Set<TItem> items) {
        return items.stream().collect(LinkedHashMap::new, (map, item) -> map.put(this.identityProvider.apply(item), item), Map::putAll);
    }
}

