/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;

@Tag(value="vaadin-combo-box")
@NpmPackage(value="@vaadin/vaadin-combo-box", version="5.0.9")
@HtmlImport(value="frontend://bower_components/vaadin-combo-box/src/vaadin-combo-box.html")
@JsModule(value="@vaadin/vaadin-combo-box/src/vaadin-combo-box.js")
public abstract class GeneratedVaadinComboBox<R extends GeneratedVaadinComboBox<R, T>, T>
extends AbstractSinglePropertyField<R, T>
implements HasStyle,
Focusable<R> {
    protected boolean isAutofocusBoolean() {
        return this.getElement().getProperty("autofocus", false);
    }

    protected void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected double getPageSizeDouble() {
        return this.getElement().getProperty("pageSize", 0.0);
    }

    protected void setPageSize(double pageSize) {
        this.getElement().setProperty("pageSize", pageSize);
    }

    protected double getSizeDouble() {
        return this.getElement().getProperty("size", 0.0);
    }

    protected void setSize(double size) {
        this.getElement().setProperty("size", size);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    protected boolean isOpenedBoolean() {
        return this.getElement().getProperty("opened", false);
    }

    protected void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    protected boolean isReadonlyBoolean() {
        return this.getElement().getProperty("readonly", false);
    }

    protected void setReadonly(boolean readonly) {
        this.getElement().setProperty("readonly", readonly);
    }

    protected JsonArray getItemsJsonArray() {
        return (JsonArray)this.getElement().getPropertyRaw("items");
    }

    protected void setItems(JsonArray items) {
        this.getElement().setPropertyJson("items", (JsonValue)items);
    }

    protected boolean isAllowCustomValueBoolean() {
        return this.getElement().getProperty("allowCustomValue", false);
    }

    protected void setAllowCustomValue(boolean allowCustomValue) {
        this.getElement().setProperty("allowCustomValue", allowCustomValue);
    }

    protected JsonArray getFilteredItemsJsonArray() {
        return (JsonArray)this.getElement().getPropertyRaw("filteredItems");
    }

    protected void setFilteredItems(JsonArray filteredItems) {
        this.getElement().setPropertyJson("filteredItems", (JsonValue)filteredItems);
    }

    protected boolean isLoadingBoolean() {
        return this.getElement().getProperty("loading", false);
    }

    protected void setLoading(boolean loading) {
        this.getElement().setProperty("loading", loading);
    }

    @Synchronize(property="filter", value={"filter-changed"})
    protected String getFilterString() {
        return this.getElement().getProperty("filter");
    }

    protected void setFilter(String filter) {
        this.getElement().setProperty("filter", filter == null ? "" : filter);
    }

    @Synchronize(property="selectedItem", value={"selected-item-changed"})
    protected JsonObject getSelectedItemJsonObject() {
        return (JsonObject)this.getElement().getPropertyRaw("selectedItem");
    }

    protected void setSelectedItem(JsonObject selectedItem) {
        this.getElement().setPropertyJson("selectedItem", (JsonValue)selectedItem);
    }

    protected String getItemLabelPathString() {
        return this.getElement().getProperty("itemLabelPath");
    }

    protected void setItemLabelPath(String itemLabelPath) {
        this.getElement().setProperty("itemLabelPath", itemLabelPath == null ? "" : itemLabelPath);
    }

    protected String getItemValuePathString() {
        return this.getElement().getProperty("itemValuePath");
    }

    protected void setItemValuePath(String itemValuePath) {
        this.getElement().setProperty("itemValuePath", itemValuePath == null ? "" : itemValuePath);
    }

    protected String getItemIdPathString() {
        return this.getElement().getProperty("itemIdPath");
    }

    protected void setItemIdPath(String itemIdPath) {
        this.getElement().setProperty("itemIdPath", itemIdPath == null ? "" : itemIdPath);
    }

    protected String getNameString() {
        return this.getElement().getProperty("name");
    }

    protected void setName(String name) {
        this.getElement().setProperty("name", name == null ? "" : name);
    }

    @Synchronize(property="invalid", value={"invalid-changed"})
    protected boolean isInvalidBoolean() {
        return this.getElement().getProperty("invalid", false);
    }

    protected void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    protected String getLabelString() {
        return this.getElement().getProperty("label");
    }

    protected void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    protected boolean isRequiredBoolean() {
        return this.getElement().getProperty("required", false);
    }

    protected void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    protected boolean isPreventInvalidInputBoolean() {
        return this.getElement().getProperty("preventInvalidInput", false);
    }

    protected void setPreventInvalidInput(boolean preventInvalidInput) {
        this.getElement().setProperty("preventInvalidInput", preventInvalidInput);
    }

    protected String getPatternString() {
        return this.getElement().getProperty("pattern");
    }

    protected void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
    }

    protected String getErrorMessageString() {
        return this.getElement().getProperty("errorMessage");
    }

    protected void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    protected String getPlaceholderString() {
        return this.getElement().getProperty("placeholder");
    }

    protected void setPlaceholder(String placeholder) {
        this.getElement().setProperty("placeholder", placeholder == null ? "" : placeholder);
    }

    protected boolean isClearButtonVisibleBoolean() {
        return this.getElement().getProperty("clearButtonVisible", false);
    }

    protected void setClearButtonVisible(boolean clearButtonVisible) {
        this.getElement().setProperty("clearButtonVisible", clearButtonVisible);
    }

    protected void clearCache() {
        this.getElement().callFunction("clearCache", new Serializable[0]);
    }

    protected void render() {
        this.getElement().callFunction("render", new Serializable[0]);
    }

    protected void open() {
        this.getElement().callFunction("open", new Serializable[0]);
    }

    protected void close() {
        this.getElement().callFunction("close", new Serializable[0]);
    }

    protected void cancel() {
        this.getElement().callFunction("cancel", new Serializable[0]);
    }

    @NotSupported
    protected void validate() {
    }

    protected void checkValidity() {
        this.getElement().callFunction("checkValidity", new Serializable[0]);
    }

    protected Registration addCustomValueSetListener(ComponentEventListener<CustomValueSetEvent<R>> listener) {
        return this.addListener(CustomValueSetEvent.class, listener);
    }

    protected Registration addSelectedItemChangeListener(ComponentEventListener<SelectedItemChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("selectedItem", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new SelectedItemChangeEvent<GeneratedVaadinComboBox>(this, event.isUserOriginated())));
    }

    protected Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new OpenedChangeEvent<GeneratedVaadinComboBox>(this, event.isUserOriginated())));
    }

    protected Registration addFilterChangeListener(ComponentEventListener<FilterChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("filter", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new FilterChangeEvent<GeneratedVaadinComboBox>(this, event.isUserOriginated())));
    }

    protected Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new InvalidChangeEvent<GeneratedVaadinComboBox>(this, event.isUserOriginated())));
    }

    protected void addToPrefix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "prefix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    protected void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public <P> GeneratedVaadinComboBox(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinComboBox(T initialValue, T defaultValue, boolean acceptNullValues) {
        super("value", defaultValue, acceptNullValues);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedVaadinComboBox(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinComboBox() {
        this(null, null, null, (SerializableFunction)null, (SerializableFunction)null);
    }

    public static class InvalidChangeEvent<R extends GeneratedVaadinComboBox<R, ?>>
    extends ComponentEvent<R> {
        private final boolean invalid;

        public InvalidChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.invalid = ((GeneratedVaadinComboBox)((Object)source)).isInvalidBoolean();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }

    public static class FilterChangeEvent<R extends GeneratedVaadinComboBox<R, ?>>
    extends ComponentEvent<R> {
        private final String filter;

        public FilterChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.filter = ((GeneratedVaadinComboBox)((Object)source)).getFilterString();
        }

        public String getFilter() {
            return this.filter;
        }
    }

    public static class OpenedChangeEvent<R extends GeneratedVaadinComboBox<R, ?>>
    extends ComponentEvent<R> {
        private final boolean opened;

        public OpenedChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((GeneratedVaadinComboBox)((Object)source)).isOpenedBoolean();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static class SelectedItemChangeEvent<R extends GeneratedVaadinComboBox<R, ?>>
    extends ComponentEvent<R> {
        private final JsonObject selectedItem;

        public SelectedItemChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.selectedItem = ((GeneratedVaadinComboBox)((Object)source)).getSelectedItemJsonObject();
        }

        public JsonObject getSelectedItem() {
            return this.selectedItem;
        }
    }

    @DomEvent(value="custom-value-set")
    public static class CustomValueSetEvent<R extends GeneratedVaadinComboBox<R, ?>>
    extends ComponentEvent<R> {
        private final String detail;

        public CustomValueSetEvent(R source, boolean fromClient, @EventData(value="event.detail") String detail) {
            super(source, fromClient);
            this.detail = detail;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

