/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox.testbench;

import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import org.openqa.selenium.By;

@Element(value="vaadin-multi-select-combo-box")
public class MultiSelectComboBoxElement
extends TestBenchElement
implements HasLabel,
HasHelper {
    public String getInputElementValue() {
        return this.getPropertyString(new String[]{"_inputElementValue"});
    }

    public void openPopup() {
        this.setProperty("opened", true);
    }

    public void closePopup() {
        this.setProperty("opened", false);
    }

    public boolean isPopupOpen() {
        return this.getPropertyBoolean(new String[]{"opened"});
    }

    public List<String> getOptions() {
        this.openPopup();
        this.waitForLoadingFinished();
        String script = "const comboBox=arguments[0];return comboBox.$.comboBox.filteredItems.map(item => item.label || '')";
        return (List)this.executeScript(script, new Object[]{this});
    }

    public void selectByText(String label) {
        this.setFilter(label);
        String script = "const combobox = arguments[0];const label = arguments[1];const itemToSelect = combobox.$.comboBox.filteredItems.find(item => item.label === label);if (!itemToSelect) return false;const isSelected = combobox.selectedItems.some(item => item.key === itemToSelect.key);if (!isSelected) {  combobox.selectedItems = [...combobox.selectedItems, itemToSelect];}return true;";
        Boolean success = (Boolean)this.executeScript(script, new Object[]{this, label});
        this.closePopup();
        if (!success.booleanValue()) {
            throw new IllegalArgumentException("Item with label '" + label + "' not found in the combobox");
        }
    }

    public void deselectByText(String label) {
        String script = "const combobox = arguments[0];const label = arguments[1];const isSelected = combobox.selectedItems.some(item => item.label === label);if (isSelected) {  combobox.selectedItems = combobox.selectedItems.filter(item => item.label !== label);}";
        this.executeScript(script, new Object[]{this, label});
    }

    public void deselectAll() {
        String script = "const combobox = arguments[0]; combobox.selectedItems = [];";
        this.executeScript(script, new Object[]{this});
    }

    public List<String> getSelectedTexts() {
        String script = "const combobox = arguments[0];return combobox.selectedItems.map(item => item.label)";
        return (List)this.executeScript(script, new Object[]{this});
    }

    public void setFilter(String filter) {
        this.openPopup();
        this.setProperty("filter", filter);
        this.waitForLoadingFinished();
    }

    public String getFilter() {
        return this.getPropertyString(new String[]{"filter"});
    }

    public void waitForLoadingFinished() {
        this.waitUntil(driver -> this.getInternalComboBox().getPropertyBoolean(new String[]{"loading"}) == false);
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.findElement(By.tagName((String)"input")).sendKeys(keysToSend);
    }

    private TestBenchElement getInternalComboBox() {
        return this.$("vaadin-multi-select-combo-box-internal").first();
    }
}

