/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.ui;

import com.vaadin.client.ui.AbstractComponentConnector;
import com.vaadin.client.ui.AbstractConnector;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.v7.client.ComponentConnector;
import com.vaadin.v7.shared.AbstractLegacyComponentState;

/**
 * Legacy connector for Vaadin 7 compatibility connectors. Needed because
 * <code>immediate</code> has been removed from {@link AbstractConnector} in
 * Vaadin 8.
 *
 * @author Vaadin Ltd
 * @since 8.0
 * @deprecated only used for Vaadin 7 compatiblity components
 */
@Deprecated
public class AbstractLegacyComponentConnector extends AbstractComponentConnector
        implements ComponentConnector {

    // overridden to be visible to VUpload in the same package. Without making
    // it public in VUploadConnector
    @Override
    protected <T extends ServerRpc> T getRpcProxy(Class<T> rpcInterface) {
        return super.getRpcProxy(rpcInterface);
    }

    @Override
    public AbstractLegacyComponentState getState() {
        return (AbstractLegacyComponentState) super.getState();
    }

    @Override
    public boolean isReadOnly() {
        return getState().readOnly;
    }

    @Override
    protected void updateWidgetStyleNames() {
        super.updateWidgetStyleNames();

        // add / remove read-only style name
        setWidgetStyleName("v-readonly", isReadOnly());
    }
}
