/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.connectors;

import com.vaadin.shared.ui.Connect;
import com.vaadin.v7.client.renderers.TextRenderer;

/**
 * A connector for {@link TextRenderer}.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
@Connect(com.vaadin.v7.ui.renderers.TextRenderer.class)
public class TextRendererConnector
        extends AbstractGridRendererConnector<String> {

    @Override
    public TextRenderer getRenderer() {
        return (TextRenderer) super.getRenderer();
    }
}
