/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.ui;

import com.google.gwt.user.client.ui.Focusable;
import com.vaadin.client.StyleConstants;
import com.vaadin.client.annotations.OnStateChange;
import com.vaadin.client.ui.HasRequiredIndicator;
import com.vaadin.v7.shared.AbstractFieldState;

@Deprecated
public abstract class AbstractFieldConnector
        extends AbstractLegacyComponentConnector
        implements HasRequiredIndicator {

    @Override
    public AbstractFieldState getState() {
        return (AbstractFieldState) super.getState();
    }

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly() || getState().propertyReadOnly;
    }

    public boolean isModified() {
        return getState().modified;
    }

    /**
     * Checks whether the required indicator should be shown for the field.
     * Required indicators are hidden if the field or its data source is
     * read-only.
     * <p>
     * NOTE: since 8.0 this only delegates to
     * {@link #isRequiredIndicatorVisible()}, and is left for legacy reasons.
     *
     * @deprecated Use {@link #isRequiredIndicatorVisible()} instead.
     *
     * @return true if required indicator should be shown
     */
    @Deprecated
    public boolean isRequired() {
        return isRequiredIndicatorVisible();
    }

    /**
     * Checks whether the required indicator should be shown for the field.
     *
     * Required indicators are hidden if the field or its data source is
     * read-only.
     *
     * @return true if required indicator should be shown
     */
    @Override
    public boolean isRequiredIndicatorVisible() {
        return getState().required && !isReadOnly();
    }

    @Override
    public boolean isErrorIndicatorVisible() {
        return super.isErrorIndicatorVisible() && !getState().hideErrors;
    }

    @Override
    protected void updateWidgetStyleNames() {
        super.updateWidgetStyleNames();

        // add / remove modified style name to Fields
        setWidgetStyleName(StyleConstants.MODIFIED, isModified());

        // add / remove error style name to Fields
        setWidgetStyleNameWithPrefix(getWidget().getStylePrimaryName(),
                StyleConstants.REQUIRED_EXT, isRequiredIndicatorVisible());

        getWidget().setStyleName(StyleConstants.REQUIRED,
                isRequiredIndicatorVisible());
    }

    @OnStateChange("tabIndex")
    void updateTabIndex() {
        // AbstractFieldState is not inheriting TabIndexState because of
        // AbstractLegacyComponentState, thus need to set tab index here
        // (instead of AbstractComponentConnector)
        if (getWidget() instanceof Focusable) {
            ((Focusable) getWidget()).setTabIndex(getState().tabIndex);
        }
    }
}
