/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.widget.grid;

import com.vaadin.v7.client.widgets.Grid.GridEvent;

/**
 * A handler for events emitted by elements in Grid.
 *
 * @param <T>
 *            the grid row type
 */
public interface GridEventHandler<T> {
    /**
     * Attempts to handle the given grid event.
     *
     * @param event
     *            the event that occurred
     */
    public void onEvent(GridEvent<T> event);
}
