/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.AbstractContainer;
import com.vaadin.v7.data.util.DefaultItemSorter;
import com.vaadin.v7.data.util.ItemSorter;
import com.vaadin.v7.data.util.ListSet;
import com.vaadin.v7.data.util.filter.UnsupportedFilterException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Deprecated
public abstract class AbstractInMemoryContainer<ITEMIDTYPE, PROPERTYIDCLASS, ITEMCLASS extends Item>
extends AbstractContainer
implements Container.ItemSetChangeNotifier,
Container.Indexed {
    private List<ITEMIDTYPE> allItemIds;
    private List<ITEMIDTYPE> filteredItemIds;
    private Set<Container.Filter> filters = new HashSet<Container.Filter>();
    private ItemSorter itemSorter = new DefaultItemSorter();

    protected AbstractInMemoryContainer() {
        this.setAllItemIds(new ListSet());
    }

    public ITEMCLASS getItem(Object itemId) {
        if (this.containsId(itemId)) {
            return this.getUnfilteredItem(itemId);
        }
        return null;
    }

    protected abstract ITEMCLASS getUnfilteredItem(Object var1);

    @Override
    public int size() {
        return this.getVisibleItemIds().size();
    }

    @Override
    public boolean containsId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        return this.getVisibleItemIds().contains(itemId);
    }

    public List<?> getItemIds() {
        return Collections.unmodifiableList(this.getVisibleItemIds());
    }

    public ITEMIDTYPE nextItemId(Object itemId) {
        int index = this.indexOfId(itemId);
        if (index >= 0 && index < this.size() - 1) {
            return this.getIdByIndex(index + 1);
        }
        return null;
    }

    public ITEMIDTYPE prevItemId(Object itemId) {
        int index = this.indexOfId(itemId);
        if (index > 0) {
            return this.getIdByIndex(index - 1);
        }
        return null;
    }

    public ITEMIDTYPE firstItemId() {
        if (this.size() > 0) {
            return this.getIdByIndex(0);
        }
        return null;
    }

    public ITEMIDTYPE lastItemId() {
        if (this.size() > 0) {
            return this.getIdByIndex(this.size() - 1);
        }
        return null;
    }

    @Override
    public boolean isFirstId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        return itemId.equals(this.firstItemId());
    }

    @Override
    public boolean isLastId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        return itemId.equals(this.lastItemId());
    }

    public ITEMIDTYPE getIdByIndex(int index) {
        return this.getVisibleItemIds().get(index);
    }

    public List<ITEMIDTYPE> getItemIds(int startIndex, int numberOfIds) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("Start index cannot be negative! startIndex=" + startIndex);
        }
        if (startIndex > this.getVisibleItemIds().size()) {
            throw new IndexOutOfBoundsException("Start index exceeds container size! startIndex=" + startIndex + " containerLastItemIndex=" + (this.getVisibleItemIds().size() - 1));
        }
        if (numberOfIds < 1) {
            if (numberOfIds == 0) {
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("Cannot get negative amount of items! numberOfItems=" + numberOfIds);
        }
        int endIndex = startIndex + numberOfIds;
        if (endIndex > this.getVisibleItemIds().size()) {
            endIndex = this.getVisibleItemIds().size();
        }
        return Collections.unmodifiableList(this.getVisibleItemIds().subList(startIndex, endIndex));
    }

    @Override
    public int indexOfId(Object itemId) {
        return this.getVisibleItemIds().indexOf(itemId);
    }

    @Override
    public Object addItemAt(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding items not supported. Override the relevant addItem*() methods if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding items not supported. Override the relevant addItem*() methods if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding items not supported. Override the relevant addItem*() methods if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding items not supported. Override the relevant addItem*() methods if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding items not supported. Override the relevant addItem*() methods if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding items not supported. Override the relevant addItem*() methods if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing items not supported. Override the removeItem() method if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing items not supported. Override the removeAllItems() method if required as specified in AbstractInMemoryContainer javadoc.");
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding container properties not supported. Override the addContainerProperty() method if required.");
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing container properties not supported. Override the addContainerProperty() method if required.");
    }

    @Override
    @Deprecated
    public void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.addItemSetChangeListener(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.removeItemSetChangeListener(listener);
    }

    @Override
    @Deprecated
    public void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    protected void filterAll() {
        if (this.doFilterContainer(!this.getFilters().isEmpty())) {
            this.fireItemSetChange();
        }
    }

    protected boolean doFilterContainer(boolean hasFilters) {
        if (!hasFilters) {
            boolean changed = this.getAllItemIds().size() != this.getVisibleItemIds().size();
            this.setFilteredItemIds(null);
            return changed;
        }
        List<Object> originalFilteredItemIds = this.getFilteredItemIds();
        boolean wasUnfiltered = false;
        if (originalFilteredItemIds == null) {
            originalFilteredItemIds = Collections.emptyList();
            wasUnfiltered = true;
        }
        this.setFilteredItemIds(new ListSet());
        boolean equal = true;
        Iterator<Object> origIt = originalFilteredItemIds.iterator();
        for (ITEMIDTYPE id : this.getAllItemIds()) {
            if (!this.passesFilters(id)) continue;
            equal = equal && origIt.hasNext() && origIt.next() == id;
            this.getFilteredItemIds().add(id);
        }
        return wasUnfiltered && !this.getAllItemIds().isEmpty() || !equal || origIt.hasNext();
    }

    protected boolean passesFilters(Object itemId) {
        ITEMCLASS item = this.getUnfilteredItem(itemId);
        if (this.getFilters().isEmpty()) {
            return true;
        }
        for (Container.Filter f : this.getFilters()) {
            if (f.passesFilter(itemId, (Item)item)) continue;
            return false;
        }
        return true;
    }

    protected void addFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.getFilters().add(filter);
        this.filterAll();
    }

    protected boolean hasContainerFilters() {
        return !this.getContainerFilters().isEmpty();
    }

    protected Collection<Container.Filter> getContainerFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    protected void removeFilter(Container.Filter filter) {
        Iterator<Container.Filter> iterator = this.getFilters().iterator();
        while (iterator.hasNext()) {
            Container.Filter f = iterator.next();
            if (!f.equals(filter)) continue;
            iterator.remove();
            this.filterAll();
            return;
        }
    }

    protected void removeAllFilters() {
        if (this.getFilters().isEmpty()) {
            return;
        }
        this.getFilters().clear();
        this.filterAll();
    }

    protected boolean isPropertyFiltered(Object propertyId) {
        if (this.getFilters().isEmpty() || propertyId == null) {
            return false;
        }
        for (Container.Filter f : this.getFilters()) {
            if (!f.appliesToProperty(propertyId)) continue;
            return true;
        }
        return false;
    }

    protected Collection<Container.Filter> removeFilters(Object propertyId) {
        if (this.getFilters().isEmpty() || propertyId == null) {
            return Collections.emptyList();
        }
        LinkedList<Container.Filter> removedFilters = new LinkedList<Container.Filter>();
        Iterator<Container.Filter> iterator = this.getFilters().iterator();
        while (iterator.hasNext()) {
            Container.Filter f = iterator.next();
            if (!f.appliesToProperty(propertyId)) continue;
            removedFilters.add(f);
            iterator.remove();
        }
        if (!removedFilters.isEmpty()) {
            this.filterAll();
            return removedFilters;
        }
        return Collections.emptyList();
    }

    protected ItemSorter getItemSorter() {
        return this.itemSorter;
    }

    protected void setItemSorter(ItemSorter itemSorter) {
        this.itemSorter = itemSorter;
    }

    protected void sortContainer(Object[] propertyId, boolean[] ascending) {
        if (!(this instanceof Container.Sortable)) {
            throw new UnsupportedOperationException("Cannot sort a Container that does not implement Sortable");
        }
        this.getItemSorter().setSortProperties((Container.Sortable)((Object)this), propertyId, ascending);
        this.doSort();
        if (this.isFiltered()) {
            this.filterAll();
        } else {
            this.fireItemSetChange();
        }
    }

    protected void doSort() {
        Collections.sort(this.getAllItemIds(), this.getItemSorter());
    }

    protected Collection<?> getSortablePropertyIds() {
        LinkedList sortables = new LinkedList();
        for (Object propertyId : this.getContainerPropertyIds()) {
            Class<?> propertyType = this.getType(propertyId);
            if (!Comparable.class.isAssignableFrom(propertyType) && !propertyType.isPrimitive()) continue;
            sortables.add(propertyId);
        }
        return sortables;
    }

    protected void internalRemoveAllItems() {
        this.getAllItemIds().clear();
        if (this.isFiltered()) {
            this.getFilteredItemIds().clear();
        }
    }

    protected boolean internalRemoveItem(Object itemId) {
        if (itemId == null) {
            return false;
        }
        boolean result = this.getAllItemIds().remove(itemId);
        if (result && this.isFiltered()) {
            this.getFilteredItemIds().remove(itemId);
        }
        return result;
    }

    private ITEMCLASS internalAddAt(int position, ITEMIDTYPE itemId, ITEMCLASS item) {
        if (position < 0 || position > this.getAllItemIds().size() || itemId == null || item == null) {
            return null;
        }
        if (this.getAllItemIds().contains(itemId)) {
            return null;
        }
        this.getAllItemIds().add(position, itemId);
        this.registerNewItem(position, itemId, item);
        return item;
    }

    protected ITEMCLASS internalAddItemAtEnd(ITEMIDTYPE newItemId, ITEMCLASS item, boolean filter) {
        ITEMCLASS newItem = this.internalAddAt(this.getAllItemIds().size(), newItemId, item);
        if (newItem != null && filter) {
            this.filterAll();
            if (!this.isFiltered()) {
                this.fireItemAdded(this.indexOfId(newItemId), newItemId, item);
            }
        }
        return newItem;
    }

    protected ITEMCLASS internalAddItemAfter(ITEMIDTYPE previousItemId, ITEMIDTYPE newItemId, ITEMCLASS item, boolean filter) {
        ITEMCLASS newItem = null;
        if (previousItemId == null) {
            newItem = this.internalAddAt(0, newItemId, item);
        } else if (this.containsId(previousItemId)) {
            newItem = this.internalAddAt(this.getAllItemIds().indexOf(previousItemId) + 1, newItemId, item);
        }
        if (newItem != null && filter) {
            this.filterAll();
            if (!this.isFiltered()) {
                this.fireItemAdded(this.indexOfId(newItemId), newItemId, item);
            }
        }
        return newItem;
    }

    protected ITEMCLASS internalAddItemAt(int index, ITEMIDTYPE newItemId, ITEMCLASS item, boolean filter) {
        if (index < 0 || index > this.size()) {
            return null;
        }
        if (index == 0) {
            return this.internalAddItemAfter(null, newItemId, item, filter);
        }
        return this.internalAddItemAfter(this.getIdByIndex(index - 1), newItemId, item, filter);
    }

    protected void registerNewItem(int position, ITEMIDTYPE itemId, ITEMCLASS item) {
    }

    protected void fireItemAdded(int position, ITEMIDTYPE itemId, ITEMCLASS item) {
        this.fireItemsAdded(position, itemId, 1);
    }

    protected void fireItemsAdded(int firstPosition, ITEMIDTYPE firstItemId, int numberOfItems) {
        BaseItemAddEvent addEvent = new BaseItemAddEvent(this, firstItemId, firstPosition, numberOfItems);
        this.fireItemSetChange(addEvent);
    }

    protected void fireItemRemoved(int position, Object itemId) {
        this.fireItemsRemoved(position, itemId, 1);
    }

    protected void fireItemsRemoved(int firstPosition, Object firstItemId, int numberOfItems) {
        BaseItemRemoveEvent removeEvent = new BaseItemRemoveEvent(this, firstItemId, firstPosition, numberOfItems);
        this.fireItemSetChange(removeEvent);
    }

    protected List<ITEMIDTYPE> getVisibleItemIds() {
        if (this.isFiltered()) {
            return this.getFilteredItemIds();
        }
        return this.getAllItemIds();
    }

    protected ITEMIDTYPE getFirstVisibleItem() {
        if (!this.getVisibleItemIds().isEmpty()) {
            return this.getVisibleItemIds().get(0);
        }
        return null;
    }

    protected boolean isFiltered() {
        return this.filteredItemIds != null;
    }

    @Deprecated
    protected void setFilteredItemIds(List<ITEMIDTYPE> filteredItemIds) {
        this.filteredItemIds = filteredItemIds;
    }

    protected List<ITEMIDTYPE> getFilteredItemIds() {
        return this.filteredItemIds;
    }

    @Deprecated
    protected void setAllItemIds(List<ITEMIDTYPE> allItemIds) {
        this.allItemIds = allItemIds;
    }

    protected List<ITEMIDTYPE> getAllItemIds() {
        return this.allItemIds;
    }

    protected void setFilters(Set<Container.Filter> filters) {
        this.filters = filters;
    }

    protected Set<Container.Filter> getFilters() {
        return this.filters;
    }

    @Deprecated
    protected static class BaseItemRemoveEvent
    extends BaseItemAddOrRemoveEvent
    implements Container.Indexed.ItemRemoveEvent {
        public BaseItemRemoveEvent(Container source, Object itemId, int index, int count) {
            super(source, itemId, index, count);
        }

        @Override
        public int getRemovedItemsCount() {
            return this.getAffectedItemsCount();
        }
    }

    @Deprecated
    protected static class BaseItemAddEvent
    extends BaseItemAddOrRemoveEvent
    implements Container.Indexed.ItemAddEvent {
        public BaseItemAddEvent(Container source, Object itemId, int index, int count) {
            super(source, itemId, index, count);
        }

        @Override
        public int getAddedItemsCount() {
            return this.getAffectedItemsCount();
        }
    }

    private static abstract class BaseItemAddOrRemoveEvent
    extends EventObject
    implements Serializable {
        protected Object itemId;
        protected int index;
        protected int count;

        public BaseItemAddOrRemoveEvent(Container source, Object itemId, int index, int count) {
            super(source);
            this.itemId = itemId;
            this.index = index;
            this.count = count;
        }

        public Container getContainer() {
            return (Container)this.getSource();
        }

        public Object getFirstItemId() {
            return this.itemId;
        }

        public int getFirstIndex() {
            return this.index;
        }

        public int getAffectedItemsCount() {
            return this.count;
        }
    }
}

