/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.shared.util.SharedUtil;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractProperty;
import com.vaadin.v7.util.SerializerHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class MethodProperty<T>
extends AbstractProperty<T> {
    private transient Object instance;
    private transient Object[] setArgs;
    private transient Object[] getArgs;
    private transient Method setMethod;
    private transient Method getMethod;
    private int setArgumentIndex;
    private transient Class<? extends T> type;
    private static final Object[] DEFAULT_GET_ARGS = new Object[0];
    private static final Object[] DEFAULT_SET_ARGS = new Object[1];

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper.writeClass(out, this.type);
        out.writeObject(this.instance);
        out.writeObject(this.setArgs);
        out.writeObject(this.getArgs);
        if (this.setMethod != null) {
            out.writeObject(this.setMethod.getName());
            SerializerHelper.writeClassArray(out, this.setMethod.getParameterTypes());
        } else {
            out.writeObject(null);
            out.writeObject(null);
        }
        if (this.getMethod != null) {
            out.writeObject(this.getMethod.getName());
            SerializerHelper.writeClassArray(out, this.getMethod.getParameterTypes());
        } else {
            out.writeObject(null);
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class<?> class1 = SerializerHelper.readClass(in);
            this.type = class1;
            this.instance = in.readObject();
            Object[] setArgs = (Object[])in.readObject();
            Object[] getArgs = (Object[])in.readObject();
            this.setArguments(getArgs, setArgs, this.setArgumentIndex);
            String name = (String)in.readObject();
            Class<?>[] paramTypes = SerializerHelper.readClassArray(in);
            this.setMethod = this.instance != null && name != null ? this.instance.getClass().getMethod(name, paramTypes) : null;
            name = (String)in.readObject();
            paramTypes = SerializerHelper.readClassArray(in);
            this.getMethod = this.instance != null && name != null ? this.instance.getClass().getMethod(name, paramTypes) : null;
        }
        catch (SecurityException e) {
            MethodProperty.getLogger().log(Level.SEVERE, "Internal deserialization error", e);
        }
        catch (NoSuchMethodException e) {
            MethodProperty.getLogger().log(Level.SEVERE, "Internal deserialization error", e);
        }
    }

    public MethodProperty(Object instance, String beanPropertyName) {
        Class<?> beanClass = instance.getClass();
        beanPropertyName = SharedUtil.capitalize((String)beanPropertyName);
        this.getMethod = null;
        try {
            this.getMethod = MethodProperty.initGetterMethod(beanPropertyName, beanClass);
        }
        catch (NoSuchMethodException ignored) {
            throw new MethodException((Property)this, "Bean property " + beanPropertyName + " can not be found");
        }
        Class<?> returnType = this.getMethod.getReturnType();
        this.setMethod = null;
        try {
            this.setMethod = beanClass.getMethod("set" + beanPropertyName, returnType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (returnType.isPrimitive()) {
            this.type = ReflectTools.convertPrimitiveType(returnType);
            if (this.type.isPrimitive()) {
                throw new MethodException((Property)this, "Bean property " + beanPropertyName + " getter return type must not be void");
            }
        } else {
            this.type = returnType;
        }
        this.setArguments(DEFAULT_GET_ARGS, DEFAULT_SET_ARGS, 0);
        this.instance = instance;
    }

    public MethodProperty(Class<? extends T> type, Object instance, String getMethodName, String setMethodName) {
        this(type, instance, getMethodName, setMethodName, new Object[0], new Object[]{null}, 0);
    }

    public MethodProperty(Class<? extends T> type, Object instance, Method getMethod, Method setMethod) {
        this(type, instance, getMethod, setMethod, new Object[0], new Object[]{null}, 0);
    }

    public MethodProperty(Class<? extends T> type, Object instance, String getMethodName, String setMethodName, Object[] getArgs, Object[] setArgs, int setArgumentIndex) {
        int j;
        Class<?>[] c;
        int i;
        if (setMethodName != null && setArgs == null) {
            throw new IndexOutOfBoundsException("The setArgs can not be null");
        }
        if (setMethodName != null && (setArgumentIndex < 0 || setArgumentIndex >= setArgs.length)) {
            throw new IndexOutOfBoundsException("The setArgumentIndex must be >= 0 and < setArgs.length");
        }
        this.type = type;
        Method[] m = instance.getClass().getMethods();
        boolean found = false;
        for (i = 0; i < m.length; ++i) {
            if (!m[i].getName().equals(getMethodName) || !type.equals(m[i].getReturnType()) || (c = m[i].getParameterTypes()).length != getArgs.length) continue;
            for (j = 0; j < c.length && (getArgs[j] == null || c[j].isAssignableFrom(getArgs[j].getClass())); ++j) {
            }
            if (j != c.length) continue;
            if (found) {
                throw new MethodException((Property)this, "Could not uniquely identify " + getMethodName + "-method");
            }
            found = true;
            this.getMethod = m[i];
        }
        if (!found) {
            throw new MethodException((Property)this, "Could not find " + getMethodName + "-method");
        }
        if (setMethodName != null) {
            found = false;
            for (i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(setMethodName) || (c = m[i].getParameterTypes()).length != setArgs.length) continue;
                for (j = 0; j < c.length && (setArgs[j] == null || c[j].isAssignableFrom(setArgs[j].getClass())) && (j != setArgumentIndex || c[j].equals(type)); ++j) {
                }
                if (j != c.length) continue;
                if (found) {
                    throw new MethodException((Property)this, "Could not identify unique " + setMethodName + "-method");
                }
                found = true;
                this.setMethod = m[i];
            }
            if (!found) {
                throw new MethodException((Property)this, "Could not identify " + setMethodName + "-method");
            }
        }
        this.type = ReflectTools.convertPrimitiveType(type);
        this.setArguments(getArgs, setArgs, setArgumentIndex);
        this.instance = instance;
    }

    public MethodProperty(Class<?> type, Object instance, Method getMethod, Method setMethod, Object[] getArgs, Object[] setArgs, int setArgumentIndex) {
        if (getMethod == null) {
            throw new MethodException((Property)this, "Property GET-method cannot not be null: " + type);
        }
        if (setMethod != null) {
            if (setArgs == null) {
                throw new IndexOutOfBoundsException("The setArgs can not be null");
            }
            if (setArgumentIndex < 0 || setArgumentIndex >= setArgs.length) {
                throw new IndexOutOfBoundsException("The setArgumentIndex must be >= 0 and < setArgs.length");
            }
        }
        Class convertedType = ReflectTools.convertPrimitiveType(type);
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.setArguments(getArgs, setArgs, setArgumentIndex);
        this.instance = instance;
        this.type = convertedType;
    }

    static Method initGetterMethod(String propertyName, Class<?> beanClass) throws NoSuchMethodException {
        propertyName = SharedUtil.capitalize((String)propertyName);
        Method getMethod = null;
        try {
            getMethod = beanClass.getMethod("get" + propertyName, new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            try {
                getMethod = beanClass.getMethod("is" + propertyName, new Class[0]);
            }
            catch (NoSuchMethodException ignoredAsWell) {
                getMethod = beanClass.getMethod("are" + propertyName, new Class[0]);
            }
        }
        return getMethod;
    }

    @Override
    public final Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly() || this.setMethod == null;
    }

    @Override
    public T getValue() {
        try {
            if (this.instance == null) {
                return null;
            }
            return (T)this.getMethod.invoke(this.instance, this.getArgs);
        }
        catch (Throwable e) {
            throw new MethodException((Property)this, e);
        }
    }

    public void setArguments(Object[] getArgs, Object[] setArgs, int setArgumentIndex) {
        this.getArgs = getArgs.length == 0 ? DEFAULT_GET_ARGS : Arrays.copyOf(getArgs, getArgs.length);
        this.setArgs = Arrays.equals(setArgs, DEFAULT_SET_ARGS) ? DEFAULT_SET_ARGS : Arrays.copyOf(setArgs, setArgs.length);
        this.setArgumentIndex = setArgumentIndex;
    }

    @Override
    public void setValue(T newValue) throws Property.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new Property.ReadOnlyException();
        }
        this.invokeSetMethod(newValue);
        this.fireValueChange();
    }

    protected void invokeSetMethod(T value) {
        try {
            if (this.setArgs.length == 1) {
                this.setMethod.invoke(this.instance, value);
            } else {
                Object[] args = new Object[this.setArgs.length];
                for (int i = 0; i < this.setArgs.length; ++i) {
                    args[i] = i == this.setArgumentIndex ? value : this.setArgs[i];
                }
                this.setMethod.invoke(this.instance, args);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new MethodException((Property)this, targetException);
        }
        catch (Exception e) {
            throw new MethodException((Property)this, (Throwable)e);
        }
    }

    @Override
    public void fireValueChange() {
        super.fireValueChange();
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        if (this.instance.getClass() != instance.getClass()) {
            throw new IllegalArgumentException("The new instance is of type " + instance.getClass().getName() + " which does not match the old instance type " + this.instance.getClass().getName());
        }
        this.instance = instance;
        this.fireValueChange();
    }

    private static final Logger getLogger() {
        return Logger.getLogger(MethodProperty.class.getName());
    }

    @Deprecated
    public static class MethodException
    extends RuntimeException {
        private final Property property;
        private Throwable cause;

        public MethodException(Property property, String msg) {
            super(msg);
            this.property = property;
        }

        public MethodException(Property property, Throwable cause) {
            this.property = property;
            this.cause = cause;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }

        public MethodProperty getMethodProperty() {
            return this.property instanceof MethodProperty ? (MethodProperty)this.property : null;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

