/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.Action;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.CompositeErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.data.Buffered;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validatable;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterUtil;
import com.vaadin.v7.shared.AbstractFieldState;
import com.vaadin.v7.ui.AbstractLegacyComponent;
import com.vaadin.v7.ui.Field;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Logger;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public abstract class AbstractField<T>
extends AbstractLegacyComponent
implements Field<T>,
Property.ReadOnlyStatusChangeListener,
Property.ReadOnlyStatusChangeNotifier,
Action.ShortcutNotifier {
    private T value;
    private Converter<T, Object> converter = null;
    private Property<?> dataSource = null;
    private LinkedList<Validator> validators = null;
    private boolean buffered;
    private boolean committingValueToDataSource = false;
    private Buffered.SourceException currentBufferedSourceException = null;
    private boolean invalidAllowed = true;
    private boolean invalidCommitted = false;
    private String requiredError = "";
    private String conversionError = "Could not convert value to {0}";
    private boolean validationVisible = true;
    private boolean valueWasModifiedByDataSourceDuringCommit;
    private boolean isListeningToPropertyEvents = false;
    private Locale valueLocale = null;
    private static final Method VALUE_CHANGE_METHOD;
    private static final Method READ_ONLY_STATUS_CHANGE_METHOD;

    protected boolean shouldHideErrors() {
        return this.isRequired() && this.isEmpty() && this.getComponentError() == null;
    }

    @Override
    public abstract Class<? extends T> getType();

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly() || this.dataSource != null && this.dataSource.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.fireReadOnlyStatusChange();
    }

    @Override
    public boolean isInvalidCommitted() {
        return this.invalidCommitted;
    }

    @Override
    public void setInvalidCommitted(boolean isCommitted) {
        this.invalidCommitted = isCommitted;
    }

    @Override
    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        if (this.dataSource != null && !this.dataSource.isReadOnly()) {
            if (this.isInvalidCommitted() || this.isValid()) {
                try {
                    this.valueWasModifiedByDataSourceDuringCommit = false;
                    this.committingValueToDataSource = true;
                    this.getPropertyDataSource().setValue(this.getConvertedValue());
                }
                catch (Throwable e) {
                    Buffered.SourceException sourceException = new Buffered.SourceException(this, e);
                    this.setCurrentBufferedSourceException(sourceException);
                    throw sourceException;
                }
                finally {
                    this.committingValueToDataSource = false;
                }
            } else {
                this.validate();
            }
        }
        if (this.isModified()) {
            this.setModified(false);
        }
        if (this.getCurrentBufferedSourceException() != null) {
            this.setCurrentBufferedSourceException(null);
        }
        if (this.valueWasModifiedByDataSourceDuringCommit) {
            this.valueWasModifiedByDataSourceDuringCommit = false;
            this.fireValueChange(false);
        }
    }

    @Override
    public void discard() throws Buffered.SourceException {
        this.updateValueFromDataSource();
    }

    private Object getDataSourceValue() {
        return this.dataSource.getValue();
    }

    private T getFieldValue() {
        if (this.dataSource == null || this.isBuffered() || this.isModified()) {
            return this.getInternalValue();
        }
        return this.convertFromModel(this.getDataSourceValue());
    }

    @Override
    public boolean isModified() {
        return this.getState((boolean)false).modified;
    }

    private void setModified(boolean modified) {
        this.getState().modified = modified;
    }

    @Override
    public void setBuffered(boolean buffered) {
        if (this.buffered == buffered) {
            return;
        }
        this.buffered = buffered;
        if (!buffered) {
            this.commit();
        }
    }

    @Override
    public boolean isBuffered() {
        return this.buffered;
    }

    @Override
    public T getValue() {
        return this.getFieldValue();
    }

    @Override
    public void setValue(T newFieldValue) throws Property.ReadOnlyException, Converter.ConversionException {
        this.setValue(newFieldValue, false);
    }

    protected void setValue(T newFieldValue, boolean repaintIsNotNeeded) {
        this.setValue(newFieldValue, repaintIsNotNeeded, false);
    }

    protected void setValue(T newFieldValue, boolean repaintIsNotNeeded, boolean ignoreReadOnly) throws Property.ReadOnlyException, Converter.ConversionException, Validator.InvalidValueException {
        if (!SharedUtil.equals(newFieldValue, this.getInternalValue())) {
            if (!ignoreReadOnly && this.isReadOnly()) {
                throw new Property.ReadOnlyException();
            }
            try {
                T doubleConvertedFieldValue = this.convertFromModel(this.convertToModel(newFieldValue));
                if (!SharedUtil.equals(newFieldValue, doubleConvertedFieldValue)) {
                    newFieldValue = doubleConvertedFieldValue;
                    repaintIsNotNeeded = false;
                }
            }
            catch (Throwable doubleConvertedFieldValue) {
                // empty catch block
            }
            if (repaintIsNotNeeded && (this.isRequired() || this.hasValidators() || this.getConverter() != null)) {
                repaintIsNotNeeded = false;
            }
            if (!this.isInvalidAllowed()) {
                this.validate(newFieldValue);
            }
            this.setInternalValue(newFieldValue);
            this.setModified(this.dataSource != null);
            this.valueWasModifiedByDataSourceDuringCommit = false;
            if (!this.isBuffered() && this.dataSource != null && (this.isInvalidCommitted() || this.isValid())) {
                try {
                    this.committingValueToDataSource = true;
                    this.getPropertyDataSource().setValue(this.convertToModel(newFieldValue));
                    this.setModified(false);
                }
                catch (Throwable e) {
                    this.currentBufferedSourceException = new Buffered.SourceException(this, e);
                    this.markAsDirty();
                    throw this.currentBufferedSourceException;
                }
                finally {
                    this.committingValueToDataSource = false;
                }
            }
            if (this.getCurrentBufferedSourceException() != null) {
                this.setCurrentBufferedSourceException(null);
            }
            if (this.valueWasModifiedByDataSourceDuringCommit) {
                repaintIsNotNeeded = false;
                this.valueWasModifiedByDataSourceDuringCommit = false;
            }
            this.fireValueChange(repaintIsNotNeeded);
        }
    }

    @Deprecated
    static boolean equals(Object value1, Object value2) {
        return SharedUtil.equals((Object)value1, (Object)value2);
    }

    @Override
    public Property getPropertyDataSource() {
        return this.dataSource;
    }

    @Override
    public void setPropertyDataSource(Property newDataSource) {
        T value;
        Collection<Validator> validators;
        T oldValue = this.getInternalValue();
        this.removePropertyListeners();
        this.dataSource = newDataSource;
        boolean bl = this.getState().propertyReadOnly = this.dataSource == null ? false : this.dataSource.isReadOnly();
        if (newDataSource != null && !ConverterUtil.canConverterPossiblyHandle(this.getConverter(), this.getType(), newDataSource.getType())) {
            this.setConverter(newDataSource.getType());
        }
        try {
            if (this.dataSource != null) {
                T fieldValue = this.convertFromModel(this.getDataSourceValue());
                this.setInternalValue(fieldValue);
            }
            this.setModified(false);
            if (this.getCurrentBufferedSourceException() != null) {
                this.setCurrentBufferedSourceException(null);
            }
        }
        catch (Throwable e) {
            this.setCurrentBufferedSourceException(new Buffered.SourceException(this, e));
            this.setModified(true);
            throw this.getCurrentBufferedSourceException();
        }
        this.addPropertyListeners();
        if (this.dataSource instanceof Validatable && (validators = ((Validatable)((Object)this.dataSource)).getValidators()) != null) {
            Iterator<Validator> i = validators.iterator();
            while (i.hasNext()) {
                this.addValidator(i.next());
            }
        }
        if ((value = this.getInternalValue()) != oldValue && (value != null && !value.equals(oldValue) || value == null)) {
            this.fireValueChange(false);
        }
    }

    public void setConverter(Class<?> datamodelType) {
        Converter<T, ?> c = ConverterUtil.getConverter(this.getType(), datamodelType, this.getSession());
        this.setConverter(c);
    }

    private T convertFromModel(Object newValue) {
        return this.convertFromModel(newValue, this.getLocale());
    }

    private T convertFromModel(Object newValue, Locale locale) {
        return ConverterUtil.convertFromModel(newValue, this.getType(), this.getConverter(), locale);
    }

    private Object convertToModel(T fieldValue) throws Converter.ConversionException {
        return this.convertToModel(fieldValue, this.getLocale());
    }

    private Object convertToModel(T fieldValue, Locale locale) throws Converter.ConversionException {
        Class<?> modelType = this.getModelType();
        try {
            return ConverterUtil.convertToModel(fieldValue, modelType, this.getConverter(), locale);
        }
        catch (Converter.ConversionException e) {
            throw new Converter.ConversionException(this.getConversionError(modelType, e), e);
        }
    }

    protected Class<?> getModelType() {
        Property pd = this.getPropertyDataSource();
        if (pd != null) {
            return pd.getType();
        }
        if (this.getConverter() != null) {
            return this.getConverter().getModelType();
        }
        return null;
    }

    protected String getConversionError(Class<?> dataSourceType, Converter.ConversionException e) {
        String conversionError = this.getConversionError();
        if (conversionError != null) {
            if (dataSourceType != null) {
                conversionError = conversionError.replace("{0}", dataSourceType.getSimpleName());
            }
            if (e != null) {
                conversionError = conversionError.replace("{1}", e.getLocalizedMessage());
            }
        }
        return conversionError;
    }

    public Object getConvertedValue() {
        return this.convertToModel(this.getFieldValue());
    }

    public void setConvertedValue(Object value) {
        this.setValue(this.convertFromModel(value));
    }

    @Override
    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new LinkedList();
        }
        this.validators.add(validator);
        this.markAsDirty();
    }

    @Override
    public Collection<Validator> getValidators() {
        if (this.validators == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.validators);
    }

    private boolean hasValidators() {
        return this.validators != null && !this.validators.isEmpty();
    }

    @Override
    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
        this.markAsDirty();
    }

    @Override
    public void removeAllValidators() {
        if (this.validators != null) {
            this.validators.clear();
        }
        this.markAsDirty();
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (Validator.InvalidValueException e) {
            return false;
        }
    }

    @Override
    public void validate() throws Validator.InvalidValueException {
        if (this.isRequired() && this.isEmpty()) {
            throw new Validator.EmptyValueException(this.requiredError);
        }
        this.validate(this.getFieldValue());
    }

    protected void validate(T fieldValue) throws Validator.InvalidValueException {
        Object valueToValidate = fieldValue;
        if (this.getConverter() != null) {
            try {
                valueToValidate = this.getConverter().convertToModel(fieldValue, this.getModelType(), this.getLocale());
            }
            catch (Converter.ConversionException e) {
                throw new Validator.InvalidValueException(this.getConversionError(this.getConverter().getModelType(), e));
            }
        }
        ArrayList<Validator.InvalidValueException> validationExceptions = new ArrayList<Validator.InvalidValueException>();
        if (this.validators != null) {
            for (Validator v : this.validators) {
                try {
                    v.validate(valueToValidate);
                }
                catch (Validator.InvalidValueException e) {
                    validationExceptions.add(e);
                }
            }
        }
        if (validationExceptions.isEmpty()) {
            return;
        }
        if (validationExceptions.size() == 1) {
            throw (Validator.InvalidValueException)validationExceptions.get(0);
        }
        Validator.InvalidValueException[] exceptionArray = validationExceptions.toArray(new Validator.InvalidValueException[validationExceptions.size()]);
        throw new Validator.InvalidValueException(null, exceptionArray);
    }

    @Override
    public boolean isInvalidAllowed() {
        return this.invalidAllowed;
    }

    @Override
    public void setInvalidAllowed(boolean invalidAllowed) throws UnsupportedOperationException {
        this.invalidAllowed = invalidAllowed;
    }

    public ErrorMessage getErrorMessage() {
        ErrorMessage superError;
        Validator.InvalidValueException validationError;
        block4: {
            validationError = null;
            if (this.isValidationVisible()) {
                try {
                    this.validate();
                }
                catch (Validator.InvalidValueException e) {
                    if (e.isInvisible()) break block4;
                    validationError = e;
                }
            }
        }
        if ((superError = super.getErrorMessage()) == null && validationError == null && this.getCurrentBufferedSourceException() == null) {
            return null;
        }
        return new CompositeErrorMessage(new ErrorMessage[]{superError, AbstractErrorMessage.getErrorMessageForException((Throwable)validationError), AbstractErrorMessage.getErrorMessageForException((Throwable)this.getCurrentBufferedSourceException())});
    }

    @Override
    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.addListener(Field.ValueChangeEvent.class, listener, VALUE_CHANGE_METHOD);
        this.markAsDirty();
    }

    @Override
    @Deprecated
    public void addListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
    }

    @Override
    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        this.removeListener(Field.ValueChangeEvent.class, listener, VALUE_CHANGE_METHOD);
        this.markAsDirty();
    }

    @Override
    @Deprecated
    public void removeListener(Property.ValueChangeListener listener) {
        this.removeValueChangeListener(listener);
    }

    protected void fireValueChange(boolean repaintIsNotNeeded) {
        this.fireEvent((EventObject)((Object)new Field.ValueChangeEvent(this)));
        if (!repaintIsNotNeeded) {
            this.markAsDirty();
        }
    }

    @Override
    public void readOnlyStatusChange(Property.ReadOnlyStatusChangeEvent event) {
        boolean readOnly = event.getProperty().isReadOnly();
        boolean shouldFireChange = this.isReadOnly() != readOnly || this.getState().propertyReadOnly != readOnly;
        this.getState().propertyReadOnly = readOnly;
        if (shouldFireChange) {
            this.fireReadOnlyStatusChange();
        }
    }

    @Override
    public void addReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
        this.addListener(Property.ReadOnlyStatusChangeEvent.class, listener, READ_ONLY_STATUS_CHANGE_METHOD);
    }

    @Override
    @Deprecated
    public void addListener(Property.ReadOnlyStatusChangeListener listener) {
        this.addReadOnlyStatusChangeListener(listener);
    }

    @Override
    public void removeReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
        this.removeListener(Property.ReadOnlyStatusChangeEvent.class, listener, READ_ONLY_STATUS_CHANGE_METHOD);
    }

    @Override
    @Deprecated
    public void removeListener(Property.ReadOnlyStatusChangeListener listener) {
        this.removeReadOnlyStatusChangeListener(listener);
    }

    protected void fireReadOnlyStatusChange() {
        this.fireEvent((EventObject)((Object)new ReadOnlyStatusChangeEvent(this)));
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        if (!this.isBuffered()) {
            if (this.committingValueToDataSource) {
                boolean propertyNotifiesOfTheBufferedValue = SharedUtil.equals(event.getProperty().getValue(), this.getInternalValue());
                if (!propertyNotifiesOfTheBufferedValue) {
                    this.readValueFromProperty(event);
                    this.valueWasModifiedByDataSourceDuringCommit = true;
                }
            } else if (!this.isModified()) {
                this.readValueFromProperty(event);
                this.fireValueChange(false);
            }
        }
    }

    private void readValueFromProperty(Property.ValueChangeEvent event) {
        this.setInternalValue(this.convertFromModel(event.getProperty().getValue()));
    }

    public void focus() {
        super.focus();
    }

    public int getTabIndex() {
        return this.getState((boolean)false).tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.getState().tabIndex = tabIndex;
    }

    protected T getInternalValue() {
        return this.value;
    }

    protected void setInternalValue(T newValue) {
        this.value = newValue;
        this.valueLocale = this.getLocale();
        if (this.validators != null && !this.validators.isEmpty()) {
            this.markAsDirty();
        }
    }

    public void attach() {
        super.attach();
        this.localeMightHaveChanged();
        if (!this.isListeningToPropertyEvents) {
            this.addPropertyListeners();
            if (!this.isModified() && !this.isBuffered()) {
                this.updateValueFromDataSource();
            }
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localeMightHaveChanged();
    }

    private void localeMightHaveChanged() {
        if (!SharedUtil.equals((Object)this.valueLocale, (Object)this.getLocale())) {
            if (this.dataSource != null && !this.isModified()) {
                T newInternalValue = this.convertFromModel(this.getPropertyDataSource().getValue());
                if (!SharedUtil.equals(newInternalValue, this.getInternalValue())) {
                    this.setInternalValue(newInternalValue);
                    this.fireValueChange(false);
                }
            } else if (this.dataSource == null && this.converter != null) {
                Object convertedValue = this.convertToModel(this.getInternalValue(), this.valueLocale);
                T newinternalValue = this.convertFromModel(convertedValue);
                if (!SharedUtil.equals(this.getInternalValue(), newinternalValue)) {
                    this.setInternalValue(newinternalValue);
                    this.fireValueChange(false);
                }
            }
        }
    }

    public void detach() {
        super.detach();
        this.removePropertyListeners();
    }

    @Override
    public boolean isRequired() {
        return this.getState((boolean)false).required;
    }

    @Override
    public void setRequired(boolean required) {
        this.getState().required = required;
    }

    @Override
    public void setRequiredError(String requiredMessage) {
        this.requiredError = requiredMessage;
        this.markAsDirty();
    }

    @Override
    public String getRequiredError() {
        return this.requiredError;
    }

    public String getConversionError() {
        return this.conversionError;
    }

    public void setConversionError(String valueConversionError) {
        this.conversionError = valueConversionError;
        this.markAsDirty();
    }

    @Override
    public boolean isEmpty() {
        return this.getFieldValue() == null;
    }

    @Override
    public void clear() {
        this.setValue(null);
    }

    public boolean isValidationVisible() {
        return this.validationVisible;
    }

    public void setValidationVisible(boolean validateAutomatically) {
        if (this.validationVisible != validateAutomatically) {
            this.markAsDirty();
            this.validationVisible = validateAutomatically;
        }
    }

    public void setCurrentBufferedSourceException(Buffered.SourceException currentBufferedSourceException) {
        this.currentBufferedSourceException = currentBufferedSourceException;
        this.markAsDirty();
    }

    protected Buffered.SourceException getCurrentBufferedSourceException() {
        return this.currentBufferedSourceException;
    }

    private void updateValueFromDataSource() {
        if (this.dataSource != null) {
            T newFieldValue;
            try {
                newFieldValue = this.convertFromModel(this.getDataSourceValue());
                if (this.getCurrentBufferedSourceException() != null) {
                    this.setCurrentBufferedSourceException(null);
                }
            }
            catch (Throwable e) {
                this.currentBufferedSourceException = new Buffered.SourceException(this, e);
                this.markAsDirty();
                throw this.currentBufferedSourceException;
            }
            boolean wasModified = this.isModified();
            this.setModified(false);
            if (!SharedUtil.equals(newFieldValue, this.getInternalValue())) {
                this.setInternalValue(newFieldValue);
                this.fireValueChange(false);
            } else if (wasModified) {
                this.markAsDirty();
            }
        }
    }

    public Converter<T, Object> getConverter() {
        return this.converter;
    }

    public void setConverter(Converter<T, ?> converter) {
        this.converter = converter;
        this.markAsDirty();
    }

    protected AbstractFieldState getState() {
        return (AbstractFieldState)super.getState();
    }

    protected AbstractFieldState getState(boolean markAsDirty) {
        return (AbstractFieldState)super.getState(markAsDirty);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        this.getState().hideErrors = this.shouldHideErrors();
    }

    private void addPropertyListeners() {
        if (!this.isListeningToPropertyEvents) {
            if (this.dataSource instanceof Property.ValueChangeNotifier) {
                ((Property.ValueChangeNotifier)((Object)this.dataSource)).addListener(this);
            }
            if (this.dataSource instanceof Property.ReadOnlyStatusChangeNotifier) {
                ((Property.ReadOnlyStatusChangeNotifier)((Object)this.dataSource)).addListener(this);
            }
            this.isListeningToPropertyEvents = true;
        }
    }

    private void removePropertyListeners() {
        if (this.isListeningToPropertyEvents) {
            if (this.dataSource instanceof Property.ValueChangeNotifier) {
                ((Property.ValueChangeNotifier)((Object)this.dataSource)).removeListener(this);
            }
            if (this.dataSource instanceof Property.ReadOnlyStatusChangeNotifier) {
                ((Property.ReadOnlyStatusChangeNotifier)((Object)this.dataSource)).removeListener(this);
            }
            this.isListeningToPropertyEvents = false;
        }
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        Attributes attr = design.attributes();
        if (design.hasAttr("readonly")) {
            this.setReadOnly((Boolean)DesignAttributeHandler.readAttribute((String)"readonly", (Attributes)attr, Boolean.class));
        }
    }

    protected Collection<String> getCustomAttributes() {
        Collection attributes = super.getCustomAttributes();
        attributes.add("readonly");
        attributes.add("value");
        attributes.add("converted-value");
        return attributes;
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        AbstractField def = (AbstractField)designContext.getDefaultInstance((Component)this);
        Attributes attr = design.attributes();
        DesignAttributeHandler.writeAttribute((String)"readonly", (Attributes)attr, (Object)super.isReadOnly(), (Object)def.isReadOnly(), Boolean.class, (DesignContext)designContext);
    }

    private static final Logger getLogger() {
        return Logger.getLogger(AbstractField.class.getName());
    }

    static {
        try {
            VALUE_CHANGE_METHOD = Property.ValueChangeListener.class.getDeclaredMethod("valueChange", Property.ValueChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in LegacyAbstractField");
        }
        try {
            READ_ONLY_STATUS_CHANGE_METHOD = Property.ReadOnlyStatusChangeListener.class.getDeclaredMethod("readOnlyStatusChange", Property.ReadOnlyStatusChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in LegacyAbstractField");
        }
    }

    @Deprecated
    public static class FocusShortcut
    extends ShortcutListener {
        protected Component.Focusable focusable;

        public FocusShortcut(Component.Focusable focusable, String shorthandCaption) {
            super(shorthandCaption);
            this.focusable = focusable;
        }

        public FocusShortcut(Component.Focusable focusable, int keyCode, int ... modifiers) {
            super(null, keyCode, modifiers);
            this.focusable = focusable;
        }

        public FocusShortcut(Component.Focusable focusable, int keyCode) {
            this(focusable, keyCode, null);
        }

        public void handleAction(Object sender, Object target) {
            this.focusable.focus();
        }
    }

    @Deprecated
    public static class ReadOnlyStatusChangeEvent
    extends Component.Event
    implements Property.ReadOnlyStatusChangeEvent,
    Serializable {
        public ReadOnlyStatusChangeEvent(AbstractField source) {
            super((Component)source);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }
}

