/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropTarget;
import com.vaadin.event.dd.TargetDetailsImpl;
import com.vaadin.event.dd.acceptcriteria.ClientSideCriterion;
import com.vaadin.event.dd.acceptcriteria.ContainsDataFlavor;
import com.vaadin.event.dd.acceptcriteria.TargetDetailIs;
import com.vaadin.server.KeyMapper;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.Resource;
import com.vaadin.server.VariableOwner;
import com.vaadin.shared.ui.dd.VerticalDropLocation;
import com.vaadin.ui.Component;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import com.vaadin.ui.declarative.DesignFormatter;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterUtil;
import com.vaadin.v7.event.DataBoundTransferable;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.shared.ui.select.AbstractSelectState;
import com.vaadin.v7.ui.AbstractField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public abstract class AbstractSelect
extends AbstractField<Object>
implements Container,
Container.Viewer,
Container.PropertySetChangeListener,
Container.PropertySetChangeNotifier,
Container.ItemSetChangeNotifier,
Container.ItemSetChangeListener,
LegacyComponent {
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_ID = ItemCaptionMode.ID;
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_ITEM = ItemCaptionMode.ITEM;
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_INDEX = ItemCaptionMode.INDEX;
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_EXPLICIT_DEFAULTS_ID = ItemCaptionMode.EXPLICIT_DEFAULTS_ID;
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_EXPLICIT = ItemCaptionMode.EXPLICIT;
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_ICON_ONLY = ItemCaptionMode.ICON_ONLY;
    @Deprecated
    public static final ItemCaptionMode ITEM_CAPTION_MODE_PROPERTY = ItemCaptionMode.PROPERTY;
    protected Container items;
    private boolean allowNewOptions;
    protected KeyMapper<Object> itemIdMapper = new KeyMapper();
    private final HashMap<Object, Resource> itemIcons = new HashMap();
    private final HashMap<Object, String> itemCaptions = new HashMap();
    private ItemCaptionMode itemCaptionMode = ItemCaptionMode.EXPLICIT_DEFAULTS_ID;
    private Object itemCaptionPropertyId = null;
    private Object itemIconPropertyId = null;
    private Set<Container.PropertySetChangeListener> propertySetEventListeners = null;
    private Set<Container.ItemSetChangeListener> itemSetEventListeners = null;
    private Object nullSelectionItemId = null;
    private boolean nullSelectionAllowed = true;
    private NewItemHandler newItemHandler;
    CaptionChangeListener captionChangeListener;

    public AbstractSelect() {
        this.setContainerDataSource(new IndexedContainer());
    }

    public AbstractSelect(String caption) {
        this.setContainerDataSource(new IndexedContainer());
        this.setCaption(caption);
    }

    public AbstractSelect(String caption, Container dataSource) {
        this.setCaption(caption);
        this.setContainerDataSource(dataSource);
    }

    public AbstractSelect(String caption, Collection<?> options) {
        IndexedContainer c = new IndexedContainer();
        if (options != null) {
            Iterator<?> i = options.iterator();
            while (i.hasNext()) {
                c.addItem(i.next());
            }
        }
        this.setCaption(caption);
        this.setContainerDataSource(c);
    }

    public void paintContent(PaintTarget target) throws PaintException {
        if (this.isNewItemsAllowed()) {
            target.addAttribute("allownewitem", true);
        }
        if (this.isNullSelectionAllowed()) {
            target.addAttribute("nullselect", true);
            if (this.getNullSelectionItemId() != null) {
                target.addAttribute("nullselectitem", true);
            }
        }
        String[] selectedKeys = this.isMultiSelect() ? new String[((Set)this.getValue()).size()] : new String[this.getValue() == null && this.getNullSelectionItemId() == null ? 0 : 1];
        this.getCaptionChangeListener().clear();
        target.startTag("options");
        int keyIndex = 0;
        Collection<?> ids = this.getItemIds();
        if (this.isNullSelectionAllowed() && this.getNullSelectionItemId() != null && !ids.contains(this.getNullSelectionItemId())) {
            Object id = this.getNullSelectionItemId();
            target.startTag("so");
            this.paintItem(target, id);
            if (this.isSelected(id)) {
                selectedKeys[keyIndex++] = this.itemIdMapper.key(id);
            }
            target.endTag("so");
        }
        for (Object id : this.getItemIds()) {
            if (!this.isNullSelectionAllowed() && id != null && id.equals(this.getNullSelectionItemId())) continue;
            String key = this.itemIdMapper.key(id);
            this.getCaptionChangeListener().addNotifierForItem(id);
            target.startTag("so");
            this.paintItem(target, id);
            if (this.isSelected(id) && keyIndex < selectedKeys.length) {
                selectedKeys[keyIndex++] = key;
            }
            target.endTag("so");
        }
        target.endTag("options");
        target.addVariable((VariableOwner)this, "selected", selectedKeys);
        if (this.isNewItemsAllowed()) {
            target.addVariable((VariableOwner)this, "newitem", "");
        }
    }

    protected void paintItem(PaintTarget target, Object itemId) throws PaintException {
        String key = this.itemIdMapper.key(itemId);
        String caption = this.getItemCaption(itemId);
        Resource icon = this.getItemIcon(itemId);
        if (icon != null) {
            target.addAttribute("icon", icon);
        }
        target.addAttribute("caption", caption);
        if (itemId != null && itemId.equals(this.getNullSelectionItemId())) {
            target.addAttribute("nullselection", true);
        }
        target.addAttribute("key", key);
        if (this.isSelected(itemId)) {
            target.addAttribute("selected", true);
        }
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        String newitem;
        if (this.isNewItemsAllowed() && (newitem = (String)variables.get("newitem")) != null && newitem.length() > 0) {
            this.getNewItemHandler().addNewItem(newitem);
        }
        if (variables.containsKey("selected")) {
            String[] clientSideSelectedKeys = (String[])variables.get("selected");
            if (this.isMultiSelect()) {
                LinkedList<Object> acceptedSelections = new LinkedList<Object>();
                for (int i = 0; i < clientSideSelectedKeys.length; ++i) {
                    Object id = this.itemIdMapper.get(clientSideSelectedKeys[i]);
                    if (!(this.isNullSelectionAllowed() || id != null && id != this.getNullSelectionItemId())) {
                        this.markAsDirty();
                        continue;
                    }
                    if (id == null || !this.containsId(id)) continue;
                    acceptedSelections.add(id);
                }
                if (!this.isNullSelectionAllowed() && acceptedSelections.size() < 1) {
                    this.markAsDirty();
                    return;
                }
                Collection visibleNotSelected = this.getVisibleItemIds();
                if (visibleNotSelected != null) {
                    visibleNotSelected = new HashSet(visibleNotSelected);
                    visibleNotSelected.removeAll(acceptedSelections);
                    LinkedHashSet<Object> newsel = (LinkedHashSet<Object>)this.getValue();
                    newsel = newsel == null ? new LinkedHashSet<Object>() : new LinkedHashSet(newsel);
                    newsel.removeAll(visibleNotSelected);
                    newsel.addAll(acceptedSelections);
                    this.setValue(newsel, true);
                }
            } else {
                if (!(this.isNullSelectionAllowed() || clientSideSelectedKeys.length != 0 && clientSideSelectedKeys[0] != null && clientSideSelectedKeys[0] != this.getNullSelectionItemId())) {
                    this.markAsDirty();
                    return;
                }
                if (clientSideSelectedKeys.length == 0) {
                    Object current = this.getValue();
                    Collection<?> visible = this.getVisibleItemIds();
                    if (visible != null && visible.contains(current)) {
                        this.setValue(null, true);
                    }
                } else {
                    String clientSelectedKey = clientSideSelectedKeys[0];
                    if ("null".equals(clientSelectedKey) || this.itemIdMapper.containsKey(clientSelectedKey)) {
                        Object id = this.itemIdMapper.get(clientSelectedKey);
                        if (!this.isNullSelectionAllowed() && id == null) {
                            this.markAsDirty();
                        } else if (id != null && id.equals(this.getNullSelectionItemId())) {
                            this.setValue(null, true);
                        } else {
                            this.setValue(id, true);
                        }
                    }
                }
            }
        }
    }

    public void setNewItemHandler(NewItemHandler newItemHandler) {
        this.newItemHandler = newItemHandler;
    }

    public NewItemHandler getNewItemHandler() {
        if (this.newItemHandler == null) {
            this.newItemHandler = new DefaultNewItemHandler();
        }
        return this.newItemHandler;
    }

    public Collection<?> getVisibleItemIds() {
        return this.getItemIds();
    }

    @Override
    public Class<?> getType() {
        if (this.isMultiSelect()) {
            return Set.class;
        }
        return Object.class;
    }

    @Override
    public Object getValue() {
        Object retValue = super.getValue();
        if (this.isMultiSelect()) {
            if (retValue == null) {
                return new HashSet();
            }
            if (retValue instanceof Set) {
                return Collections.unmodifiableSet((Set)retValue);
            }
            if (retValue instanceof Collection) {
                return new HashSet((Collection)retValue);
            }
            HashSet s = new HashSet();
            if (this.items.containsId(retValue)) {
                s.add(retValue);
            }
            return s;
        }
        return retValue;
    }

    @Override
    public void setValue(Object newValue) throws Property.ReadOnlyException {
        if (newValue == this.getNullSelectionItemId()) {
            newValue = null;
        }
        this.setValue(newValue, false);
    }

    @Override
    protected void setValue(Object newFieldValue, boolean repaintIsNotNeeded, boolean ignoreReadOnly) throws Property.ReadOnlyException, Converter.ConversionException, Validator.InvalidValueException {
        if (this.isMultiSelect()) {
            if (newFieldValue == null) {
                super.setValue(new LinkedHashSet(), repaintIsNotNeeded, ignoreReadOnly);
            } else if (Collection.class.isAssignableFrom(newFieldValue.getClass())) {
                super.setValue(new LinkedHashSet((Collection)newFieldValue), repaintIsNotNeeded, ignoreReadOnly);
            }
        } else if (newFieldValue == null || this.items.containsId(newFieldValue)) {
            super.setValue(newFieldValue, repaintIsNotNeeded, ignoreReadOnly);
        }
    }

    @Override
    public Item getItem(Object itemId) {
        return this.items.getItem(itemId);
    }

    @Override
    public Collection<?> getItemIds() {
        return this.items.getItemIds();
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return this.items.getContainerPropertyIds();
    }

    @Override
    public Class<?> getType(Object propertyId) {
        return this.items.getType(propertyId);
    }

    @Override
    public int size() {
        int size = this.items.size();
        assert (size >= 0);
        return size;
    }

    @Override
    public boolean containsId(Object itemId) {
        if (itemId != null) {
            return this.items.containsId(itemId);
        }
        return false;
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        return this.items.getContainerProperty(itemId, propertyId);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        boolean retval = this.items.addContainerProperty(propertyId, type, defaultValue);
        if (retval && !(this.items instanceof Container.PropertySetChangeNotifier)) {
            this.firePropertySetChange();
        }
        return retval;
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        boolean retval = this.items.removeAllItems();
        this.itemIdMapper.removeAll();
        if (retval) {
            this.setValue((Object)null);
            if (!(this.items instanceof Container.ItemSetChangeNotifier)) {
                this.fireItemSetChange();
            }
        }
        return retval;
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        Object retval = this.items.addItem();
        if (retval != null && !(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.fireItemSetChange();
        }
        return retval;
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        Item retval = this.items.addItem(itemId);
        if (retval != null && !(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.fireItemSetChange();
        }
        return retval;
    }

    public void addItems(Object ... itemId) throws UnsupportedOperationException {
        for (Object id : itemId) {
            this.addItem(id);
        }
    }

    public void addItems(Collection<?> itemIds) throws UnsupportedOperationException {
        this.addItems(itemIds.toArray());
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        this.unselect(itemId);
        boolean retval = this.items.removeItem(itemId);
        this.itemIdMapper.remove(itemId);
        if (retval && !(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.fireItemSetChange();
        }
        return retval;
    }

    public void sanitizeSelection() {
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        boolean changed = false;
        if (this.isMultiSelect()) {
            Collection valueAsCollection = (Collection)value;
            ArrayList newSelection = new ArrayList(valueAsCollection.size());
            for (Object subValue : valueAsCollection) {
                if (this.containsId(subValue)) {
                    newSelection.add(subValue);
                    continue;
                }
                changed = true;
            }
            if (changed) {
                this.setValue(newSelection);
            }
        } else if (!this.containsId(value)) {
            this.setValue((Object)null);
        }
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        boolean retval = this.items.removeContainerProperty(propertyId);
        if (retval && !(this.items instanceof Container.PropertySetChangeNotifier)) {
            this.firePropertySetChange();
        }
        return retval;
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        if (newDataSource == null) {
            newDataSource = new IndexedContainer();
        }
        this.getCaptionChangeListener().clear();
        if (this.items != newDataSource) {
            if (this.items != null) {
                if (this.items instanceof Container.ItemSetChangeNotifier) {
                    ((Container.ItemSetChangeNotifier)((Object)this.items)).removeItemSetChangeListener(this);
                }
                if (this.items instanceof Container.PropertySetChangeNotifier) {
                    ((Container.PropertySetChangeNotifier)((Object)this.items)).removePropertySetChangeListener(this);
                }
            }
            this.items = newDataSource;
            this.itemIdMapper.removeAll();
            if (this.items != null) {
                if (this.items instanceof Container.ItemSetChangeNotifier) {
                    ((Container.ItemSetChangeNotifier)((Object)this.items)).addItemSetChangeListener(this);
                }
                if (this.items instanceof Container.PropertySetChangeNotifier) {
                    ((Container.PropertySetChangeNotifier)((Object)this.items)).addPropertySetChangeListener(this);
                }
            }
            this.setValue((Object)null);
            this.markAsDirty();
        }
    }

    @Override
    public Container getContainerDataSource() {
        return this.items;
    }

    public boolean isMultiSelect() {
        return this.getState((boolean)false).multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        if (multiSelect && this.getNullSelectionItemId() != null) {
            throw new IllegalStateException("Multiselect and NullSelectionItemId can not be set at the same time.");
        }
        if (multiSelect != this.getState((boolean)false).multiSelect) {
            Object oldValue = this.getValue();
            this.getState().multiSelect = multiSelect;
            if (multiSelect) {
                HashSet<Object> s = new HashSet<Object>();
                if (oldValue != null) {
                    s.add(oldValue);
                }
                this.setValue(s);
            } else {
                Set s = (Set)oldValue;
                if (s == null || s.isEmpty()) {
                    this.setValue((Object)null);
                } else {
                    this.setValue(s.iterator().next());
                }
            }
            this.markAsDirty();
        }
    }

    public boolean isNewItemsAllowed() {
        return this.allowNewOptions;
    }

    public void setNewItemsAllowed(boolean allowNewOptions) {
        if (this.allowNewOptions != allowNewOptions) {
            this.allowNewOptions = allowNewOptions;
            this.markAsDirty();
        }
    }

    public void setItemCaption(Object itemId, String caption) {
        if (itemId != null) {
            this.itemCaptions.put(itemId, caption);
            this.markAsDirty();
        }
    }

    public String getItemCaption(Object itemId) {
        if (itemId == null) {
            return null;
        }
        String caption = null;
        switch (this.getItemCaptionMode()) {
            case ID: {
                caption = this.idToCaption(itemId);
                break;
            }
            case ID_TOSTRING: {
                caption = itemId.toString();
                break;
            }
            case INDEX: {
                if (this.items instanceof Container.Indexed) {
                    caption = String.valueOf(((Container.Indexed)this.items).indexOfId(itemId));
                    break;
                }
                caption = "ERROR: Container is not indexed";
                break;
            }
            case ITEM: {
                Item i = this.getItem(itemId);
                if (i == null) break;
                caption = i.toString();
                break;
            }
            case EXPLICIT: {
                caption = this.itemCaptions.get(itemId);
                break;
            }
            case EXPLICIT_DEFAULTS_ID: {
                caption = this.itemCaptions.get(itemId);
                if (caption != null) break;
                caption = this.idToCaption(itemId);
                break;
            }
            case PROPERTY: {
                Object value;
                Property p = this.getContainerProperty(itemId, this.getItemCaptionPropertyId());
                if (p == null || (value = p.getValue()) == null) break;
                caption = value.toString();
            }
        }
        return caption != null ? caption : "";
    }

    private String idToCaption(Object itemId) {
        try {
            Converter<String, ?> c = ConverterUtil.getConverter(String.class, itemId.getClass(), this.getSession());
            return ConverterUtil.convertFromModel(itemId, String.class, c, this.getLocale());
        }
        catch (Exception e) {
            return itemId.toString();
        }
    }

    public void setItemIcon(Object itemId, Resource icon) {
        if (itemId != null) {
            if (icon == null) {
                this.itemIcons.remove(itemId);
            } else {
                this.itemIcons.put(itemId, icon);
            }
            this.markAsDirty();
        }
    }

    public Resource getItemIcon(Object itemId) {
        Resource explicit = this.itemIcons.get(itemId);
        if (explicit != null) {
            return explicit;
        }
        if (this.getItemIconPropertyId() == null) {
            return null;
        }
        Property ip = this.getContainerProperty(itemId, this.getItemIconPropertyId());
        if (ip == null) {
            return null;
        }
        Object icon = ip.getValue();
        if (icon instanceof Resource) {
            return (Resource)icon;
        }
        return null;
    }

    public void setItemCaptionMode(ItemCaptionMode mode) {
        if (mode != null) {
            this.itemCaptionMode = mode;
            this.markAsDirty();
        }
    }

    public ItemCaptionMode getItemCaptionMode() {
        return this.itemCaptionMode;
    }

    public void setItemCaptionPropertyId(Object propertyId) {
        if (propertyId != null) {
            this.itemCaptionPropertyId = propertyId;
            this.setItemCaptionMode(ITEM_CAPTION_MODE_PROPERTY);
            this.markAsDirty();
        } else {
            this.itemCaptionPropertyId = null;
            if (this.getItemCaptionMode() == ITEM_CAPTION_MODE_PROPERTY) {
                this.setItemCaptionMode(ITEM_CAPTION_MODE_EXPLICIT_DEFAULTS_ID);
            }
            this.markAsDirty();
        }
    }

    public Object getItemCaptionPropertyId() {
        return this.itemCaptionPropertyId;
    }

    public void setItemIconPropertyId(Object propertyId) throws IllegalArgumentException {
        if (propertyId == null) {
            this.itemIconPropertyId = null;
        } else {
            if (!this.getContainerPropertyIds().contains(propertyId)) {
                throw new IllegalArgumentException("Property id not found in the container");
            }
            if (Resource.class.isAssignableFrom(this.getType(propertyId))) {
                this.itemIconPropertyId = propertyId;
            } else {
                throw new IllegalArgumentException("Property type must be assignable to Resource");
            }
        }
        this.markAsDirty();
    }

    public Object getItemIconPropertyId() {
        return this.itemIconPropertyId;
    }

    public boolean isSelected(Object itemId) {
        if (itemId == null) {
            return false;
        }
        if (this.isMultiSelect()) {
            return ((Set)this.getValue()).contains(itemId);
        }
        Object value = this.getValue();
        return itemId.equals(value == null ? this.getNullSelectionItemId() : value);
    }

    public void select(Object itemId) {
        if (!this.isMultiSelect()) {
            this.setValue(itemId);
        } else if (!this.isSelected(itemId) && itemId != null && this.items.containsId(itemId)) {
            HashSet<Object> s = new HashSet<Object>((Set)this.getValue());
            s.add(itemId);
            this.setValue(s);
        }
    }

    public void unselect(Object itemId) {
        if (this.isSelected(itemId)) {
            if (this.isMultiSelect()) {
                HashSet s = new HashSet((Set)this.getValue());
                s.remove(itemId);
                this.setValue(s);
            } else {
                this.setValue((Object)null);
            }
        }
    }

    @Override
    public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
        this.firePropertySetChange();
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.propertySetEventListeners == null) {
            this.propertySetEventListeners = new LinkedHashSet<Container.PropertySetChangeListener>();
        }
        this.propertySetEventListeners.add(listener);
    }

    @Override
    @Deprecated
    public void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.propertySetEventListeners != null) {
            this.propertySetEventListeners.remove(listener);
            if (this.propertySetEventListeners.isEmpty()) {
                this.propertySetEventListeners = null;
            }
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.itemSetEventListeners == null) {
            this.itemSetEventListeners = new LinkedHashSet<Container.ItemSetChangeListener>();
        }
        this.itemSetEventListeners.add(listener);
    }

    @Override
    @Deprecated
    public void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.itemSetEventListeners != null) {
            this.itemSetEventListeners.remove(listener);
            if (this.itemSetEventListeners.isEmpty()) {
                this.itemSetEventListeners = null;
            }
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    public Collection<?> getListeners(Class<?> eventType) {
        if (Container.ItemSetChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.itemSetEventListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.itemSetEventListeners);
        }
        if (Container.PropertySetChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.propertySetEventListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.propertySetEventListeners);
        }
        return super.getListeners(eventType);
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.itemIdMapper.removeAll();
        this.fireItemSetChange();
    }

    protected void firePropertySetChange() {
        if (this.propertySetEventListeners != null && !this.propertySetEventListeners.isEmpty()) {
            PropertySetChangeEvent event = new PropertySetChangeEvent(this);
            Object[] listeners = this.propertySetEventListeners.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((Container.PropertySetChangeListener)listeners[i]).containerPropertySetChange(event);
            }
        }
        this.markAsDirty();
    }

    protected void fireItemSetChange() {
        if (this.itemSetEventListeners != null && !this.itemSetEventListeners.isEmpty()) {
            ItemSetChangeEvent event = new ItemSetChangeEvent(this);
            Object[] listeners = this.itemSetEventListeners.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((Container.ItemSetChangeListener)listeners[i]).containerItemSetChange(event);
            }
        }
        this.markAsDirty();
    }

    @Override
    public boolean isEmpty() {
        if (!this.isMultiSelect()) {
            return super.isEmpty();
        }
        Object value = this.getValue();
        return super.isEmpty() || value instanceof Collection && ((Collection)value).isEmpty();
    }

    public void setNullSelectionAllowed(boolean nullSelectionAllowed) {
        if (nullSelectionAllowed != this.nullSelectionAllowed) {
            this.nullSelectionAllowed = nullSelectionAllowed;
            this.markAsDirty();
        }
    }

    public boolean isNullSelectionAllowed() {
        return this.nullSelectionAllowed;
    }

    public Object getNullSelectionItemId() {
        return this.nullSelectionItemId;
    }

    public void setNullSelectionItemId(Object nullSelectionItemId) {
        if (nullSelectionItemId != null && this.isMultiSelect()) {
            throw new IllegalStateException("Multiselect and NullSelectionItemId can not be set at the same time.");
        }
        this.nullSelectionItemId = nullSelectionItemId;
    }

    @Override
    public void attach() {
        super.attach();
    }

    @Override
    public void detach() {
        this.getCaptionChangeListener().clear();
        super.detach();
    }

    protected CaptionChangeListener getCaptionChangeListener() {
        if (this.captionChangeListener == null) {
            this.captionChangeListener = new CaptionChangeListener();
        }
        return this.captionChangeListener;
    }

    @Override
    public void readDesign(Element design, DesignContext context) {
        super.readDesign(design, context);
        this.readItems(design, context);
    }

    protected void readItems(Element design, DesignContext context) {
        HashSet<String> selected = new HashSet<String>();
        for (Element child : design.children()) {
            this.readItem(child, selected, context);
        }
        if (!selected.isEmpty()) {
            if (this.isMultiSelect()) {
                this.setValue(selected, false, true);
            } else if (selected.size() == 1) {
                this.setValue(selected.iterator().next(), false, true);
            } else {
                throw new DesignException("Multiple values selected for a single select component");
            }
        }
    }

    protected Object readItem(Element child, Set<String> selected, DesignContext context) {
        String itemId;
        if (!"option".equals(child.tagName())) {
            throw new DesignException("Unrecognized child element in " + this.getClass().getSimpleName() + ": " + child.tagName());
        }
        String caption = DesignFormatter.decodeFromTextNode((String)child.html());
        if (child.hasAttr("item-id")) {
            itemId = child.attr("item-id");
            this.addItem(itemId);
            this.setItemCaption(itemId, caption);
        } else {
            itemId = caption;
            this.addItem(itemId);
        }
        if (child.hasAttr("icon")) {
            this.setItemIcon(itemId, (Resource)DesignAttributeHandler.readAttribute((String)"icon", (Attributes)child.attributes(), Resource.class));
        }
        if (child.hasAttr("selected")) {
            selected.add(itemId);
        }
        return itemId;
    }

    @Override
    public void writeDesign(Element design, DesignContext context) {
        super.writeDesign(design, context);
        if (context.shouldWriteData((Component)this)) {
            this.writeItems(design, context);
        }
    }

    protected void writeItems(Element design, DesignContext context) {
        for (Object itemId : this.getItemIds()) {
            this.writeItem(design, itemId, context);
        }
    }

    protected Element writeItem(Element design, Object itemId, DesignContext context) {
        Element element = design.appendElement("option");
        String caption = this.getItemCaption(itemId);
        if (caption != null && !caption.equals(itemId.toString())) {
            element.html(DesignFormatter.encodeForTextNode((String)caption));
            element.attr("item-id", itemId.toString());
        } else {
            element.html(DesignFormatter.encodeForTextNode((String)itemId.toString()));
        }
        Resource icon = this.getItemIcon(itemId);
        if (icon != null) {
            DesignAttributeHandler.writeAttribute((String)"icon", (Attributes)element.attributes(), (Object)icon, null, Resource.class, (DesignContext)context);
        }
        if (this.isSelected(itemId)) {
            element.attr("selected", "");
        }
        return element;
    }

    protected AbstractSelectState getState() {
        return (AbstractSelectState)super.getState();
    }

    protected AbstractSelectState getState(boolean markAsDirty) {
        return (AbstractSelectState)super.getState(markAsDirty);
    }

    @Deprecated
    public static interface ItemDescriptionGenerator
    extends Serializable {
        public String generateDescription(Component var1, Object var2, Object var3);
    }

    @Deprecated
    public static class VerticalLocationIs
    extends TargetDetailIs {
        public static VerticalLocationIs TOP = new VerticalLocationIs(VerticalDropLocation.TOP);
        public static VerticalLocationIs BOTTOM = new VerticalLocationIs(VerticalDropLocation.BOTTOM);
        public static VerticalLocationIs MIDDLE = new VerticalLocationIs(VerticalDropLocation.MIDDLE);

        private VerticalLocationIs(VerticalDropLocation l) {
            super("detail", l.name());
        }
    }

    @Deprecated
    public class AbstractSelectTargetDetails
    extends TargetDetailsImpl {
        protected Object idOver;

        protected AbstractSelectTargetDetails(Map<String, Object> rawVariables) {
            super(rawVariables, (DropTarget)AbstractSelect.this);
            String keyover = (String)this.getData("itemIdOver");
            if (keyover != null) {
                this.idOver = AbstractSelect.this.itemIdMapper.get(keyover);
            }
        }

        public Object getItemIdOver() {
            return this.idOver;
        }

        public VerticalDropLocation getDropLocation() {
            String detail = (String)this.getData("detail");
            if (detail == null) {
                return null;
            }
            return VerticalDropLocation.valueOf((String)detail);
        }
    }

    @Deprecated
    public static class AcceptItem
    extends AbstractItemSetCriterion {
        public static final ClientSideCriterion ALL = new ContainsDataFlavor("itemId");

        public AcceptItem(AbstractSelect select, Object ... itemId) {
            super(select, itemId);
        }

        public boolean accept(DragAndDropEvent dragEvent) {
            DataBoundTransferable transferable = (DataBoundTransferable)dragEvent.getTransferable();
            if (transferable.getSourceComponent() != this.select) {
                return false;
            }
            return this.itemIds.contains(transferable.getItemId());
        }
    }

    private static abstract class AbstractItemSetCriterion
    extends ClientSideCriterion {
        protected final Collection<Object> itemIds = new HashSet<Object>();
        protected AbstractSelect select;

        public AbstractItemSetCriterion(AbstractSelect select, Object ... itemId) {
            if (this.itemIds == null || select == null) {
                throw new IllegalArgumentException("Accepted item identifiers must be accepted.");
            }
            Collections.addAll(this.itemIds, itemId);
            this.select = select;
        }

        public void paintContent(PaintTarget target) throws PaintException {
            super.paintContent(target);
            Object[] keys = new String[this.itemIds.size()];
            int i = 0;
            for (Object itemId : this.itemIds) {
                String key = this.select.itemIdMapper.key(itemId);
                keys[i++] = key;
            }
            target.addAttribute("keys", keys);
            target.addAttribute("s", (Component)this.select);
        }
    }

    @Deprecated
    public static class TargetItemIs
    extends AbstractItemSetCriterion {
        public TargetItemIs(AbstractSelect select, Object ... itemId) {
            super(select, itemId);
        }

        public boolean accept(DragAndDropEvent dragEvent) {
            AbstractSelectTargetDetails dropTargetData = (AbstractSelectTargetDetails)dragEvent.getTargetDetails();
            if (dropTargetData.getTarget() != this.select) {
                return false;
            }
            return this.itemIds.contains(dropTargetData.getItemIdOver());
        }
    }

    @Deprecated
    protected class CaptionChangeListener
    implements Item.PropertySetChangeListener,
    Property.ValueChangeListener {
        HashSet<Object> captionChangeNotifiers = new HashSet();

        protected CaptionChangeListener() {
        }

        public void addNotifierForItem(Object itemId) {
            Property p;
            switch (AbstractSelect.this.getItemCaptionMode()) {
                case ITEM: {
                    Collection<?> pids;
                    Item i = AbstractSelect.this.getItem(itemId);
                    if (i == null) {
                        return;
                    }
                    if (i instanceof Item.PropertySetChangeNotifier) {
                        ((Item.PropertySetChangeNotifier)((Object)i)).addPropertySetChangeListener(AbstractSelect.this.getCaptionChangeListener());
                        this.captionChangeNotifiers.add(i);
                    }
                    if ((pids = i.getItemPropertyIds()) == null) break;
                    Iterator<?> it = pids.iterator();
                    while (it.hasNext()) {
                        Property p2 = i.getItemProperty(it.next());
                        if (p2 == null || !(p2 instanceof Property.ValueChangeNotifier)) continue;
                        ((Property.ValueChangeNotifier)((Object)p2)).addValueChangeListener(AbstractSelect.this.getCaptionChangeListener());
                        this.captionChangeNotifiers.add(p2);
                    }
                    break;
                }
                case PROPERTY: {
                    Property p3 = AbstractSelect.this.getContainerProperty(itemId, AbstractSelect.this.getItemCaptionPropertyId());
                    if (p3 == null || !(p3 instanceof Property.ValueChangeNotifier)) break;
                    ((Property.ValueChangeNotifier)((Object)p3)).addValueChangeListener(AbstractSelect.this.getCaptionChangeListener());
                    this.captionChangeNotifiers.add(p3);
                }
            }
            if (AbstractSelect.this.getItemIconPropertyId() != null && (p = AbstractSelect.this.getContainerProperty(itemId, AbstractSelect.this.getItemIconPropertyId())) != null && p instanceof Property.ValueChangeNotifier) {
                ((Property.ValueChangeNotifier)((Object)p)).addValueChangeListener(AbstractSelect.this.getCaptionChangeListener());
                this.captionChangeNotifiers.add(p);
            }
        }

        public void clear() {
            for (Object notifier : this.captionChangeNotifiers) {
                if (notifier instanceof Item.PropertySetChangeNotifier) {
                    ((Item.PropertySetChangeNotifier)notifier).removePropertySetChangeListener(AbstractSelect.this.getCaptionChangeListener());
                    continue;
                }
                ((Property.ValueChangeNotifier)notifier).removeValueChangeListener(AbstractSelect.this.getCaptionChangeListener());
            }
            this.captionChangeNotifiers.clear();
        }

        @Override
        public void valueChange(Property.ValueChangeEvent event) {
            AbstractSelect.this.markAsDirty();
        }

        @Override
        public void itemPropertySetChange(Item.PropertySetChangeEvent event) {
            AbstractSelect.this.markAsDirty();
        }
    }

    private static class PropertySetChangeEvent
    extends EventObject
    implements Container.PropertySetChangeEvent,
    Serializable {
        private PropertySetChangeEvent(Container source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }

    private static class ItemSetChangeEvent
    extends EventObject
    implements Serializable,
    Container.ItemSetChangeEvent {
        private ItemSetChangeEvent(Container source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }

    @Deprecated
    public class DefaultNewItemHandler
    implements NewItemHandler {
        @Override
        public void addNewItem(String newItemCaption) {
            if (AbstractSelect.this.isReadOnly()) {
                throw new Property.ReadOnlyException();
            }
            if (AbstractSelect.this.addItem(newItemCaption) != null) {
                if (AbstractSelect.this.getItemCaptionPropertyId() != null) {
                    AbstractSelect.this.getContainerProperty(newItemCaption, AbstractSelect.this.getItemCaptionPropertyId()).setValue(newItemCaption);
                }
                if (AbstractSelect.this.isMultiSelect()) {
                    HashSet<String> values = new HashSet<String>((Collection)AbstractSelect.this.getValue());
                    values.add(newItemCaption);
                    AbstractSelect.this.setValue(values);
                } else {
                    AbstractSelect.this.setValue(newItemCaption);
                }
            }
        }
    }

    @Deprecated
    public static interface NewItemHandler
    extends Serializable {
        public void addNewItem(String var1);
    }

    @Deprecated
    public static interface Filtering
    extends Serializable {
        @Deprecated
        public static final FilteringMode FILTERINGMODE_OFF = FilteringMode.OFF;
        @Deprecated
        public static final FilteringMode FILTERINGMODE_STARTSWITH = FilteringMode.STARTSWITH;
        @Deprecated
        public static final FilteringMode FILTERINGMODE_CONTAINS = FilteringMode.CONTAINS;

        public void setFilteringMode(FilteringMode var1);

        public FilteringMode getFilteringMode();
    }

    @Deprecated
    public static enum ItemCaptionMode {
        ID,
        ID_TOSTRING,
        ITEM,
        INDEX,
        EXPLICIT_DEFAULTS_ID,
        EXPLICIT,
        ICON_ONLY,
        PROPERTY;

    }
}

