/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignFormatter;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterUtil;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.shared.ui.label.LabelState;
import com.vaadin.v7.ui.AbstractLegacyComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.Locale;
import org.jsoup.nodes.Element;

@Deprecated
public class Label
extends AbstractLegacyComponent
implements Property<String>,
Property.Viewer,
Property.ValueChangeListener,
Property.ValueChangeNotifier,
Comparable<Label> {
    @Deprecated
    public static final ContentMode CONTENT_TEXT = ContentMode.TEXT;
    @Deprecated
    public static final ContentMode CONTENT_PREFORMATTED = ContentMode.PREFORMATTED;
    @Deprecated
    public static final ContentMode CONTENT_XHTML = ContentMode.HTML;
    @Deprecated
    public static final ContentMode CONTENT_XML = ContentMode.XML;
    @Deprecated
    public static final ContentMode CONTENT_RAW = ContentMode.RAW;
    @Deprecated
    public static final ContentMode CONTENT_DEFAULT = ContentMode.TEXT;
    private Converter<String, Object> converter = null;
    private Property<String> dataSource = null;
    private static final Method VALUE_CHANGE_METHOD;

    public Label() {
        this("");
    }

    public Label(String content) {
        this(content, ContentMode.TEXT);
    }

    public Label(Property contentSource) {
        this(contentSource, ContentMode.TEXT);
    }

    public Label(String content, ContentMode contentMode) {
        this.setValue(content);
        this.setContentMode(contentMode);
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
    }

    public Label(Property contentSource, ContentMode contentMode) {
        this.setPropertyDataSource(contentSource);
        this.setContentMode(contentMode);
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
    }

    protected LabelState getState() {
        return (LabelState)super.getState();
    }

    protected LabelState getState(boolean markAsDirty) {
        return (LabelState)super.getState(markAsDirty);
    }

    @Override
    public String getValue() {
        if (this.getPropertyDataSource() == null) {
            return this.getState((boolean)false).text;
        }
        return this.getDataSourceValue();
    }

    private String getDataSourceValue() {
        return ConverterUtil.convertFromModel(this.getPropertyDataSource().getValue(), String.class, this.getConverter(), this.getLocale());
    }

    @Override
    public void setValue(String newStringValue) {
        if (this.getPropertyDataSource() == null) {
            LabelState state = this.getState(false);
            String oldTextValue = state.text;
            if (!SharedUtil.equals((Object)oldTextValue, (Object)newStringValue)) {
                this.getState().text = newStringValue;
                this.fireValueChange();
            }
        } else {
            throw new IllegalStateException("Label is only a Property.Viewer and cannot update its data source");
        }
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public Property getPropertyDataSource() {
        return this.dataSource;
    }

    @Override
    public void setPropertyDataSource(Property newDataSource) {
        if (this.dataSource != null && Property.ValueChangeNotifier.class.isAssignableFrom(this.dataSource.getClass())) {
            ((Property.ValueChangeNotifier)((Object)this.dataSource)).removeListener(this);
        }
        if (newDataSource != null && !ConverterUtil.canConverterPossiblyHandle(this.getConverter(), this.getType(), newDataSource.getType())) {
            Converter c = ConverterUtil.getConverter(String.class, newDataSource.getType(), this.getSession());
            this.setConverter(c);
        }
        this.dataSource = newDataSource;
        if (this.dataSource != null) {
            this.updateValueFromDataSource();
        }
        if (this.dataSource != null && Property.ValueChangeNotifier.class.isAssignableFrom(this.dataSource.getClass())) {
            ((Property.ValueChangeNotifier)((Object)this.dataSource)).addListener(this);
        }
        this.markAsDirty();
    }

    public ContentMode getContentMode() {
        return this.getState((boolean)false).contentMode;
    }

    public void setContentMode(ContentMode contentMode) {
        if (contentMode == null) {
            throw new IllegalArgumentException("Content mode can not be null");
        }
        this.getState().contentMode = contentMode;
    }

    @Override
    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.addListener(ValueChangeEvent.class, listener, VALUE_CHANGE_METHOD);
    }

    @Override
    @Deprecated
    public void addListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
    }

    @Override
    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        this.removeListener(ValueChangeEvent.class, listener, VALUE_CHANGE_METHOD);
    }

    @Override
    @Deprecated
    public void removeListener(Property.ValueChangeListener listener) {
        this.removeValueChangeListener(listener);
    }

    protected void fireValueChange() {
        this.fireEvent((EventObject)((Object)new ValueChangeEvent(this)));
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        this.updateValueFromDataSource();
    }

    private void updateValueFromDataSource() {
        String newConvertedValue = this.getDataSourceValue();
        if (!SharedUtil.equals((Object)newConvertedValue, (Object)this.getState((boolean)false).text)) {
            this.getState().text = newConvertedValue;
            this.fireValueChange();
        }
    }

    public void attach() {
        super.attach();
        this.localeMightHaveChanged();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localeMightHaveChanged();
    }

    private void localeMightHaveChanged() {
        if (this.getPropertyDataSource() != null) {
            this.updateValueFromDataSource();
        }
    }

    private String getComparableValue() {
        String stringValue = this.getValue();
        if (stringValue == null) {
            stringValue = "";
        }
        if (this.getContentMode() == ContentMode.HTML || this.getContentMode() == ContentMode.XML) {
            return this.stripTags(stringValue);
        }
        return stringValue;
    }

    @Override
    public int compareTo(Label other) {
        String thisValue = this.getComparableValue();
        String otherValue = other.getComparableValue();
        return thisValue.compareTo(otherValue);
    }

    private String stripTags(String xml) {
        StringBuffer res = new StringBuffer();
        int processed = 0;
        int xmlLen = xml.length();
        while (processed < xmlLen) {
            int next = xml.indexOf(60, processed);
            if (next < 0) {
                next = xmlLen;
            }
            res.append(xml.substring(processed, next));
            if (processed >= xmlLen) continue;
            next = xml.indexOf(62, processed);
            if (next < 0) {
                next = xmlLen;
            }
            processed = next + 1;
        }
        return res.toString();
    }

    public Converter<String, Object> getConverter() {
        return this.converter;
    }

    public void setConverter(Converter<String, ?> converter) {
        this.converter = converter;
        this.markAsDirty();
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        String innerHtml = design.html();
        boolean plainText = design.hasAttr("plain-text");
        if (plainText) {
            this.setContentMode(ContentMode.TEXT);
        } else {
            this.setContentMode(ContentMode.HTML);
        }
        if (innerHtml != null && !"".equals(innerHtml)) {
            if (plainText) {
                innerHtml = DesignFormatter.decodeFromTextNode((String)innerHtml);
            }
            this.setValue(innerHtml);
        }
    }

    protected Collection<String> getCustomAttributes() {
        Collection result = super.getCustomAttributes();
        result.add("value");
        result.add("content-mode");
        result.add("plain-text");
        return result;
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        String content = this.getValue();
        if (content != null) {
            switch (this.getContentMode()) {
                case TEXT: 
                case PREFORMATTED: 
                case XML: 
                case RAW: {
                    design.attr("plain-text", true);
                    String encodeForTextNode = DesignFormatter.encodeForTextNode((String)content);
                    if (encodeForTextNode == null) break;
                    design.html(encodeForTextNode);
                    break;
                }
                case HTML: {
                    design.html(content);
                    break;
                }
                default: {
                    throw new IllegalStateException("ContentMode " + this.getContentMode() + " is not supported by writeDesign");
                }
            }
        }
    }

    static {
        try {
            VALUE_CHANGE_METHOD = Property.ValueChangeListener.class.getDeclaredMethod("valueChange", Property.ValueChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in Label");
        }
    }

    @Deprecated
    public static class ValueChangeEvent
    extends Component.Event
    implements Property.ValueChangeEvent {
        public ValueChangeEvent(Label source) {
            super((Component)source);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }
}

