/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignFormatter;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.optiongroup.OptionGroupState;
import com.vaadin.v7.ui.AbstractSelect;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jsoup.nodes.Element;

@Deprecated
public class OptionGroup
extends AbstractSelect
implements FieldEvents.BlurNotifier,
FieldEvents.FocusNotifier {
    private Set<Object> disabledItemIds = new HashSet<Object>();

    public OptionGroup() {
    }

    public OptionGroup(String caption, Collection<?> options) {
        super(caption, options);
    }

    public OptionGroup(String caption, Container dataSource) {
        super(caption, dataSource);
    }

    public OptionGroup(String caption) {
        super(caption);
    }

    @Override
    protected void paintItem(PaintTarget target, Object itemId) throws PaintException {
        super.paintItem(target, itemId);
        if (!this.isItemEnabled(itemId)) {
            target.addAttribute("disabled", true);
        }
    }

    @Override
    public void changeVariables(Object source, Map<String, Object> variables) {
        super.changeVariables(source, variables);
        if (variables.containsKey("focus")) {
            this.fireEvent((EventObject)new FieldEvents.FocusEvent((Component)this));
        }
        if (variables.containsKey("blur")) {
            this.fireEvent((EventObject)new FieldEvents.BlurEvent((Component)this));
        }
    }

    @Override
    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.addListener("blur", FieldEvents.BlurEvent.class, listener, FieldEvents.BlurListener.blurMethod);
    }

    @Override
    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.removeListener("blur", FieldEvents.BlurEvent.class, listener);
    }

    @Override
    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.addListener("focus", FieldEvents.FocusEvent.class, listener, FieldEvents.FocusListener.focusMethod);
    }

    @Override
    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.removeListener("focus", FieldEvents.FocusEvent.class, listener);
    }

    @Override
    protected void setValue(Object newValue, boolean repaintIsNotNeeded) {
        if (repaintIsNotNeeded) {
            if (this.isMultiSelect()) {
                Set currentValueSet = (Set)this.getValue();
                Set newValueSet = (Set)newValue;
                for (Object itemId : currentValueSet) {
                    if (this.isItemEnabled(itemId) || newValueSet.contains(itemId)) continue;
                    this.markAsDirty();
                    return;
                }
                for (Object itemId : newValueSet) {
                    if (this.isItemEnabled(itemId) || currentValueSet.contains(itemId)) continue;
                    this.markAsDirty();
                    return;
                }
            } else {
                if (newValue == null) {
                    newValue = this.getNullSelectionItemId();
                }
                if (!this.isItemEnabled(newValue)) {
                    this.markAsDirty();
                    return;
                }
            }
        }
        super.setValue(newValue, repaintIsNotNeeded);
    }

    public void setItemEnabled(Object itemId, boolean enabled) {
        if (itemId != null) {
            if (enabled) {
                this.disabledItemIds.remove(itemId);
            } else {
                this.disabledItemIds.add(itemId);
            }
            this.markAsDirty();
        }
    }

    public boolean isItemEnabled(Object itemId) {
        if (itemId != null) {
            return !this.disabledItemIds.contains(itemId);
        }
        return true;
    }

    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.getState().htmlContentAllowed = htmlContentAllowed;
    }

    public boolean isHtmlContentAllowed() {
        return this.getState((boolean)false).htmlContentAllowed;
    }

    @Override
    protected Object readItem(Element child, Set<String> selected, DesignContext context) {
        Object itemId = super.readItem(child, selected, context);
        if (child.hasAttr("disabled")) {
            this.setItemEnabled(itemId, false);
        }
        return itemId;
    }

    @Override
    protected Element writeItem(Element design, Object itemId, DesignContext context) {
        Element elem = super.writeItem(design, itemId, context);
        if (!this.isItemEnabled(itemId)) {
            elem.attr("disabled", "");
        }
        if (this.isHtmlContentAllowed()) {
            elem.html(DesignFormatter.decodeFromTextNode((String)elem.html()));
        }
        return elem;
    }

    protected OptionGroupState getState() {
        return (OptionGroupState)super.getState();
    }

    protected OptionGroupState getState(boolean markAsDirty) {
        return (OptionGroupState)super.getState(markAsDirty);
    }
}

