/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.v7.ui;

import java.util.Date;

import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.ui.DateTimeField;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.datefield.PopupDateFieldState;

/**
 * <p>
 * A date entry component, which displays the actual date selector as a popup.
 *
 * </p>
 *
 * @see DateField
 * @see InlineDateField
 * @author Vaadin Ltd.
 * @since 5.0
 *
 * @deprecated As of 8.0, use {@link com.vaadin.ui.DateField} or
 *             {@link DateTimeField} instead.
 */
@Deprecated
public class PopupDateField extends DateField {

    private String inputPrompt = null;

    public PopupDateField() {
        super();
    }

    public PopupDateField(Property dataSource) throws IllegalArgumentException {
        super(dataSource);
    }

    public PopupDateField(String caption, Date value) {
        super(caption, value);
    }

    public PopupDateField(String caption, Property dataSource) {
        super(caption, dataSource);
    }

    public PopupDateField(String caption) {
        super(caption);
    }

    @Override
    public void paintContent(PaintTarget target) throws PaintException {
        super.paintContent(target);

        if (inputPrompt != null) {
            target.addAttribute("prompt", inputPrompt);
        }
    }

    /**
     * Gets the current input prompt.
     *
     * @see #setInputPrompt(String)
     * @return the current input prompt, or null if not enabled
     */
    public String getInputPrompt() {
        return inputPrompt;
    }

    /**
     * Sets the input prompt - a textual prompt that is displayed when the field
     * would otherwise be empty, to prompt the user for input.
     *
     * @param inputPrompt
     */
    public void setInputPrompt(String inputPrompt) {
        this.inputPrompt = inputPrompt;
        markAsDirty();
    }

    @Override
    protected PopupDateFieldState getState() {
        return (PopupDateFieldState) super.getState();
    }

    @Override
    protected PopupDateFieldState getState(boolean markAsDirty) {
        return (PopupDateFieldState) super.getState(markAsDirty);
    }

    /**
     * Checks whether the text field is enabled (default) or not.
     *
     * @see #setTextFieldEnabled(boolean)
     *
     * @return <b>true</b> if the text field is enabled, <b>false</b> otherwise.
     */
    public boolean isTextFieldEnabled() {
        return getState(false).textFieldEnabled;
    }

    /**
     * Enables or disables the text field. By default the text field is enabled.
     * Disabling it causes only the button for date selection to be active, thus
     * preventing the user from entering invalid dates.
     *
     * See <a href="http://dev.vaadin.com/ticket/6790">Ticket 6790</a>".
     *
     * @param state
     *            <b>true</b> to enable text field, <b>false</b> to disable it.
     */
    public void setTextFieldEnabled(boolean state) {
        getState().textFieldEnabled = state;
    }

    /**
     * Set a description that explains the usage of the Widget for users of
     * assistive devices.
     *
     * @param description
     *            String with the description
     */
    public void setAssistiveText(String description) {
        getState().descriptionForAssistiveDevices = description;
    }

    /**
     * Get the description that explains the usage of the Widget for users of
     * assistive devices.
     *
     * @return String with the description
     */
    public String getAssistiveText() {
        return getState(false).descriptionForAssistiveDevices;
    }
}
