/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.compatibility.themes;

import java.util.ArrayList;
import java.util.List;

import org.osgi.service.component.annotations.Component;

import com.vaadin.osgi.resources.OsgiVaadinContributor;
import com.vaadin.osgi.resources.OsgiVaadinResource;
import com.vaadin.osgi.resources.OsgiVaadinTheme;

@Component
public class LegacyThemeContributions implements OsgiVaadinContributor {
    private static final String[] LEGACY_THEMES = { "base", "chameleon",
            "reindeer", "runo" };

    @Override
    public List<OsgiVaadinResource> getContributions() {
        final List<OsgiVaadinResource> contributions = new ArrayList<>(
                LEGACY_THEMES.length);
        for (final String theme : LEGACY_THEMES) {
            contributions.add(OsgiVaadinTheme.create(theme));
        }
        return contributions;
    }
}
