/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.confirmdialog;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="vaadin-confirm-dialog")
@HtmlImport(value="frontend://bower_components/vaadin-confirm-dialog/src/vaadin-confirm-dialog.html")
public class ConfirmDialog
extends Component
implements HasSize,
HasStyle,
HasOrderedComponents<ConfirmDialog> {
    private boolean autoAddedToTheUi;

    public ConfirmDialog() {
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener) {
        this();
        this.setHeader(header);
        this.setText(text);
        this.setConfirmButton(confirmText, confirmListener);
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener, String cancelText, ComponentEventListener<CancelEvent> cancelListener) {
        this(header, text, confirmText, confirmListener);
        this.setCancelButton(cancelText, cancelListener);
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener, String rejectText, ComponentEventListener<RejectEvent> rejectListener, String cancelText, ComponentEventListener<CancelEvent> cancelListener) {
        this(header, text, confirmText, confirmListener, cancelText, cancelListener);
        this.setRejectButton(rejectText, rejectListener);
    }

    public void setCancelable(boolean cancelable) {
        this.getElement().setProperty("cancel", cancelable);
    }

    public void setRejectable(boolean rejectable) {
        this.getElement().setProperty("reject", rejectable);
    }

    public void setRejectButton(String buttonText, ComponentEventListener<RejectEvent> rejectListener) {
        this.setRejectable(true);
        this.setRejectText(buttonText);
        this.addRejectListener(rejectListener);
    }

    public void setRejectButton(String buttonText, ComponentEventListener<RejectEvent> rejectListener, String theme) {
        this.setRejectButton(buttonText, rejectListener);
        this.setRejectButtonTheme(theme);
    }

    public void setRejectButton(Component component) {
        this.setRejectButton(component.getElement());
    }

    public void setRejectButton(Element element) {
        this.addToSlot("reject-button", element);
    }

    public void setCancelButton(String buttonText, ComponentEventListener<CancelEvent> cancelListener) {
        this.setCancelable(true);
        this.setCancelText(buttonText);
        this.addCancelListener(cancelListener);
    }

    public void setCancelButton(String buttonText, ComponentEventListener<CancelEvent> cancelListener, String theme) {
        this.setCancelButton(buttonText, cancelListener);
        this.setCancelButtonTheme(theme);
    }

    public void setCancelButton(Component component) {
        this.setCancelButton(component.getElement());
    }

    public void setCancelButton(Element element) {
        this.addToSlot("cancel-button", element);
    }

    public void setConfirmButton(String buttonText, ComponentEventListener<ConfirmEvent> confirmListener) {
        this.setConfirmText(buttonText);
        this.addConfirmListener(confirmListener);
    }

    public void setConfirmButton(String buttonText, ComponentEventListener<ConfirmEvent> confirmListener, String theme) {
        this.setConfirmButton(buttonText, confirmListener);
        this.setConfirmButtonTheme(theme);
    }

    public void setConfirmButton(Component component) {
        this.setConfirmButton(component.getElement());
    }

    public void setConfirmButton(Element element) {
        this.addToSlot("confirm-button", element);
    }

    private void addToSlot(String slotName, Element element) {
        element.setAttribute("slot", slotName);
        this.getElement().appendChild(new Element[]{element});
    }

    public void setText(String message) {
        this.getElement().setProperty("message", message);
    }

    public void setText(Component component) {
        this.setText(component.getElement());
    }

    public void setText(Element element) {
        this.getElement().appendChild(new Element[]{element});
    }

    public void setConfirmText(String confirmText) {
        this.getElement().setProperty("confirmText", confirmText);
    }

    public void setConfirmButtonTheme(String confirmTheme) {
        this.getElement().setProperty("confirmTheme", confirmTheme);
    }

    public Registration addConfirmListener(ComponentEventListener<ConfirmEvent> listener) {
        return ComponentUtil.addListener((Component)this, ConfirmEvent.class, listener);
    }

    public void setCancelText(String cancelText) {
        this.getElement().setProperty("cancelText", cancelText);
    }

    public void setCancelButtonTheme(String cancelTheme) {
        this.getElement().setProperty("cancelTheme", cancelTheme);
    }

    public Registration addCancelListener(ComponentEventListener<CancelEvent> listener) {
        return ComponentUtil.addListener((Component)this, CancelEvent.class, listener);
    }

    public void setRejectText(String rejectText) {
        this.getElement().setProperty("rejectText", rejectText);
    }

    public void setRejectButtonTheme(String rejectTheme) {
        this.getElement().setProperty("rejectTheme", rejectTheme);
    }

    public Registration addRejectListener(ComponentEventListener<RejectEvent> listener) {
        return ComponentUtil.addListener((Component)this, RejectEvent.class, listener);
    }

    public void setHeader(String header) {
        this.getElement().setProperty("header", header);
    }

    public void setHeader(Component component) {
        this.setHeader(component.getElement());
    }

    public void setHeader(Element element) {
        this.addToSlot("header", element);
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        if (opened) {
            this.ensureAttached();
        }
        this.getElement().setProperty("opened", opened);
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void ensureAttached() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            });
        }
    }

    @DomEvent(value="cancel")
    public static class CancelEvent
    extends ComponentEvent<ConfirmDialog> {
        public CancelEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="reject")
    public static class RejectEvent
    extends ComponentEvent<ConfirmDialog> {
        public RejectEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="confirm")
    public static class ConfirmEvent
    extends ComponentEvent<ConfirmDialog> {
        public ConfirmEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

